<?php

namespace FluentForm\App\Modules\Form;

use FluentForm\App;
use FluentForm\Framework\Helpers\ArrayHelper;

class Predefined extends Form
{
    /**
     * all JSON data will be stored here
     * @return  array
     */
    private function getPredefinedForms()
    {
        $forms = array(

            'blank_form' => array(
                'screenshot' => App::publicUrl('img/forms/new_blank.png'),
                'createable' => true,
                'title'      => 'Blank Form',
                'tag'        => ["blank"],
                'category'   => 'Basic',
                'brief'      => '',
                'json'       => '[{"id":"132","title":"Blank Form","form":{"fields":[],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","asteriskPlacement": "asterisk-right"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            // 'login_form' => array(
            //     'screenshot' => App::publicUrl('img/forms/login_form.png'),
            //     'createable' => true,
            //     'title'      => 'Login Form',
            //     'tag'        => ["login", 'sign-in', 'signin'],
            //     'category'   => 'Basic',
            //     'type'       => 'login_form',
            //     'brief'      => 'Create a built-in login form',
            //     'json'       => '[{"id":"40","title":"Login Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"username","value":"","class":"","placeholder":"","maxlength":""},"settings":{"container_class":"","label":"Username \/ Email","label_placement":"","admin_field_label":"","help_message":"","prefix_label":"","suffix_label":"","validation_rules":{"required":{"value":true,"message":"The username field is required."}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"is_unique":"no","unique_validation_message":"This value need to be unique."},"editor_options":{"title":"Simple Text","icon_class":"ff-edit-text","template":"inputText"},"uniqElKey":"el_16439840653180.5950104089952024"},{"index":12,"element":"input_password","attributes":{"type":"password","name":"password","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Password","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"The password field is required."}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Password Field","icon_class":"ff-edit-password","template":"inputText"},"uniqElKey":"el_16439840677840.8106538437875277"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"remember","value":[]},"settings":{"dynamic_default_value":"","container_class":"","label":"Checkbox Field","admin_field_label":"","label_placement":"hide_label","display_type":"","help_message":"","advanced_options":[{"label":"Remember Me","value":"Remember Me","calc_value":"","image":"","id":0}],"calc_value_status":false,"enable_image_input":false,"values_visible":false,"randomize_options":"no","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"layout_class":""},"editor_options":{"title":"Check Box","icon_class":"ff-edit-checkbox-1","template":"inputCheckable"},"uniqElKey":"el_16439840708000.3612537438431451"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Login","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"0","type":"form","conditions":null,"created_by":"1","created_at":"2022-02-04 14:14:14","updated_at":"2022-02-04 14:16:22","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<p>You\'ve been logged in successfully.<\/p>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\",\"selectedDays\":[\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\",\"Sunday\"]},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}"},{"meta_key":"template_name","value":"blank_form"},{"meta_key":"_primary_email_field","value":""}]}]'
            // ),

            'basic_contact_form' => array(
                'screenshot' => App::publicUrl('img/forms/contact_form.png'),
                'createable' => true,
                'title'      => 'Contact Form',
                'is_pro'     => false,
                'brief'      => 'Create a basic contact form',
                'category'   => "Basic",
                'tag'        => ["contact", "registration", "form", "basic"],
                'json'       => '[{"id":"15","title":"Contact Form Demo","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name"},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_1570866006692"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_1570866012914"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"subject","value":"","class":"","placeholder":"Subject"},"settings":{"container_class":"","label":"Subject","label_placement":"","admin_field_label":"Subject","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Simple Text","icon_class":"ff-edit-text","template":"inputText"},"uniqElKey":"el_1570878958648"},{"index":3,"element":"textarea","attributes":{"name":"message","value":"","id":"","class":"","placeholder":"Your Message","rows":4,"cols":2},"settings":{"container_class":"","label":"Your Message","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Text Area","icon_class":"ff-edit-textarea","template":"inputTextarea"},"uniqElKey":"el_1570879001207"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","asteriskPlacement":"asterisk-right"},"id":"39"},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'conversational'  => array(
                'screenshot' => App::publicUrl('img/forms/conversational.gif'),
                'createable' => true,
                'title'      => 'Conversational Form',
                'brief'      => 'Create Smart form UI',
                'category'   => 'Basic',
                'tag'        => ['contact', 'typeform', 'conversational', 'form'],
                'json'       => '[{"id":"8","title":"Conversational Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":"eg: John Doe","maxlength":""},"settings":{"container_class":"","label":"Your Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"This value need to be unique."},"editor_options":{"title":"Simple Text","icon_class":"ff-edit-text","template":"inputText"},"style_pref":{"layout":"default","media":"' . $this->getRandomPhoto() . '","brightness":0,"alt_text":"","media_x_position":50,"media_y_position":50},"uniqElKey":"el_16225264130200.4393750282723139"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"Please Provide your Email Address","admin_field_label":"Email Address","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"style_pref":{"layout":"default","media":"' . $this->getRandomPhoto() . '","brightness":0,"alt_text":"","media_x_position":50,"media_y_position":50},"uniqElKey":"el_16225264372080.5731140635572141"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":"Query Subject","maxlength":""},"settings":{"container_class":"","label":"Subject","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"This value need to be unique."},"editor_options":{"title":"Simple Text","icon_class":"ff-edit-text","template":"inputText"},"style_pref":{"layout":"default","media":"' . $this->getRandomPhoto() . '","brightness":0,"alt_text":"","media_x_position":50,"media_y_position":50},"uniqElKey":"el_16225264620550.8688317001333026"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"Your Query","rows":3,"cols":2,"maxlength":""},"settings":{"container_class":"","label":"Your Query","admin_field_label":"Query","label_placement":"","help_message":"Please let us know details about your query","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Text Area","icon_class":"ff-edit-textarea","template":"inputTextarea"},"style_pref":{"layout":"default","media":"' . $this->getRandomPhoto() . '","brightness":0,"alt_text":"","media_x_position":50,"media_y_position":50},"uniqElKey":"el_16225264839650.04799061605619115"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"0","type":"form","conditions":null,"created_by":"1","created_at":"2021-06-01 05:25:54","updated_at":"2021-06-01 05:48:59","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<h2>Thank you for your message. We will get in touch with you shortly<\/h2>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\",\"selectedDays\":[\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\",\"Sunday\"]},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let us hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}"},{"meta_key":"is_conversion_form","value":"yes"},{"meta_key":"step_data_persistency_status","value":"no"},{"meta_key":"_primary_email_field","value":"email"}]}]'
            ),

            //form number : 84
            'newsletter_form' => array(
                'screenshot' => App::publicUrl('img/forms/comment_rating.png'),
                'createable' => true,
                'title'      => 'Newsletter Form',
                'is_pro'     => false,
                'brief'      => 'This form can be used to create newsletters.',
                'category'   => "Basic",
                'tag'        => ["Newsletter", "website", "tech", "subscriber"],
                'json'       => '[{"id":"84","title":"Newsletter Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"<h3 style=\"text-align: center;\">Subscribe to our newsletter<\/h3>\n<p style=\"text-align: center;\">Welcome to our Newsletter Subscription Center. Sign up in the newsletter form below to receive the latest news and updates from our company.<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570690779710"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570702292674"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"left","help_message":"N:B: We will send you an email describing how to activate your newsletter subscription.","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570690876531"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"right","button_style":"red","container_class":"","help_message":"","background_color":"#F56C6C","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Subscribe","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),


            'support_form' => array(
                'screenshot' => App::publicUrl('img/forms/support_form.png'),
                'createable' => true,
                'title'      => 'Support Form',
                'brief'      => 'Using this support form users can ask questions.',
                'category'   => "Basic",
                'tag'        => ["support", "request", "contact"],
                'json'       => '[{"id":"4","title":"Support Form","form":{"fields":[{"index":2,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"First Name field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1516797727681"},{"index":7,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"you@domain.com"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Email field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1516797731343"},{"index":3,"element":"select","attributes":{"name":"department","value":"","id":"","class":""},"settings":{"label":"Department","help_message":"","container_class":"","label_placement":"","placeholder":"- Select Department -","validation_rules":{"required":{"value":true,"message":"Department field is required"}},"conditional_logics":[]},"options":{"Web Design":"Web Design","Web Development":"Web Development","WordPress Development":"WordPress Development","DevOps":"DevOps"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1516797735245"},{"index":1,"element":"input_text","attributes":{"type":"text","name":"subject","value":"","class":"","placeholder":"Type your subject"},"settings":{"container_class":"","label":"Subject","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Subject field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Input","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1516797770161"},{"index":2,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Description","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1516797774136"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Support Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"{inputs.subject}, Support Form","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'inline_subscription' => array(
                'screenshot' => App::publicUrl('img/forms/inline_subscription.png'),
                'createable' => true,
                'title'      => 'Optin Form',
                'brief'      => 'Create inline optin form.',
                'category'   => "Basic",
                'tag'        => ["optin form", "newsletter"],
                'json' => '[{"id":"8","title":"Subscription Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":1,"element":"container","attributes":[],"settings":{"container_class":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Your Email Address"},"settings":{"container_class":"","label":"","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_16231279686950.8779857923682932"}]},{"fields":[{"index":15,"element":"custom_submit_button","attributes":{"class":"","type":"submit"},"settings":{"button_style":"","button_size":"md","align":"left","container_class":"","current_state":"normal_styles","background_color":"","color":"","hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":"100%"},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":"100%"},"button_ui":{"text":"Subscribe","type":"default","img_url":""},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom Submit Button","icon_class":"dashicons dashicons-arrow-right-alt","template":"customButton"},"uniqElKey":"el_16231279798380.5947400167493171"}]}],"editor_options":{"title":"Two Column Container","icon_class":"ff-edit-column-2"},"uniqElKey":"el_16231279284710.40955091024524304"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Subscribe","img_url":""}},"editor_options":{"title":"Submit Button"}}},"has_payment":"0","type":"form","conditions":null,"created_by":"1","created_at":"2021-06-08 04:51:36","updated_at":"2021-06-08 04:54:02","metas":[{"meta_key": "template_name","value": "inline_subscription"},{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Thank you for your message. We will get in touch with you shortly\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"}}"},{"meta_key":"notifications","value":"{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}<\\\/p>\\n<p>This form submitted at: {embed_post.permalink}<\\\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}"},{"meta_key":"step_data_persistency_status","value":"no"},{"meta_key":"_primary_email_field","value":"email"}]}]'
            ),

            'polling_form'                          => array(
                'screenshot' => App::publicUrl('img/forms/polling_form.png'),
                'createable' => true,
                'title'      => 'Polling Form',
                'brief'      => 'A sample polling form to get user opinion from your scheduled time.',
                'category'   => "Marketing",
                'tag'        => ["poll", "vote", "quiz", "test"],
                'json'       => '[{"id":"14","title":"Polling Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Full Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Full Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559116201333"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559116203187"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Which game you want to play?","admin_field_label":"Which game you want to play?","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Football":"Football","Cricket":"Cricket","Hocky":"Hocky"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1559116572343"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Time of the match?","admin_field_label":"Time of the match?","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Morning":"Morning","Afternoon":"Afternoon","Any time":"Any time"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559116394587"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Put your suggestion  (optional)","admin_field_label":"suggestions","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559188488518"}],"submitButton":{"uniqElKey":"el_1559116097684","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"green","container_class":"","help_message":"","background_color":"#67C23A","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Your opinion","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Polling Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Polling Form","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 55
            'product_order_form'                    => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Product Order Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to create a product order. (Payment Module is required)',
                'category'   => "Product",
                'tag'        => ["Shopping", "online order", "customer", "contact", "payment"],
                'json'       => '[{"id":"200","title":"Product Order Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[],"label_placement":"top"},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name","maxlength":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"Middle Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_15924974034200.26712438122064186"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_15924974402130.012591725433457768"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address_1","data-type":"address-element"},"settings":{"label":"Shipping Address","admin_field_label":"Address","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":"Address Line 1"},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":"Address Line 2"},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":"City"},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":"State"},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"Zip","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"Select Country","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"priority_based","visible_list":[],"hidden_list":[],"priority_based":[]},"conditional_logics":[]},"options":{"US":"US of America","UK":"United Kingdom"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"ff-edit-address","template":"addressFields"},"uniqElKey":"el_15924974518640.796545629032311"},{"index":8,"element":"multi_payment_component","attributes":{"type":"checkbox","name":"payment_input","value":""},"settings":{"container_class":"","label":"Choose your Products","admin_field_label":"Product","label_placement":"","display_type":"","help_message":"","is_payment_field":"yes","pricing_options":[{"label":"Product Item 1 - $10","value":10,"image":""},{"label":"Product Item 2 - $19","value":"19"},{"label":"Product Item 3 - $29","value":"29"}],"price_label":"Price:","enable_quantity":false,"enable_image_input":false,"is_element_lock":false,"layout_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Payment Field","icon_class":"ff-edit-shopping-cart","element":"input-radio","template":"inputMultiPayment"},"uniqElKey":"el_1592497499371"},{"index":10,"element":"payment_method","attributes":{"name":"payment_method","type":"radio","value":""},"settings":{"container_class":"","label":"Choose Payment Method","default_method":"","label_placement":"","help_message":"","payment_methods":{"stripe":{"title":"Credit\/Debit Card (Stripe)","enabled":"yes","method_value":"stripe","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with Card (Stripe)","label":"Method Label"},"require_billing_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Billing info"},"require_shipping_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Collect Shipping Info"}}},"paypal":{"title":"PayPal","enabled":"yes","method_value":"paypal","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with PayPal","label":"Method Label"},"require_shipping_address":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Shipping Address"}}},"test":{"title":"Test Payment","enabled":"yes","method_value":"test","settings":{"option_label":{"type":"text","template":"inputText","value":"Test Payment","label":"Method Label"}}}},"admin_field_label":"","conditional_logics":[]},"editor_options":{"title":"Payment Method Field","icon_class":"ff-edit-credit-card","template":"inputPaymentMethods"},"uniqElKey":"el_15924975611200.8035560583323771"},{"index":20,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>Some description about this section<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"container_class":""},"editor_options":{"title":"Custom HTML","icon_class":"ff-edit-html","template":"customHTML"},"uniqElKey":"el_15924975898180.429874118645158"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Purchase {payment_total}","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"1","type":"form","conditions":null,"created_by":"1","created_at":"2020-06-18 23:34:18","updated_at":"2020-06-18 23:35:03","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<p>Thank you for your order<\/p> <p>{payment.receipt}<\/p>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"New Order Notification to Admin\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<h4>Order Items<\/h4> <p>{payment.order_items}<\/p> <h4>Other Data:<\/h4> <p>{all_data}<\/p> <p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"step_data_persistency_status","value":"no"},{"meta_key":"_payment_settings","value":"{\"currency\":\"USD\",\"push_meta_to_stripe\":\"no\",\"receipt_email\":\"email\",\"transaction_type\":\"product\",\"stripe_checkout_methods\":[\"card\"],\"stripe_meta_data\":[{\"item_value\":\"\",\"label\":\"\"}]}"},{"meta_key":"notifications","value":"{\"name\":\"Email To Customer\",\"sendTo\":{\"type\":\"field\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] Your Order Receipt\",\"message\":\"<p>{payment.receipt}<\/p> <p>Thank you<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"advancedValidationSettings","value":"{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}"},{"meta_key":"report_data_migrated","value":"\"yes\""}]}]'
            ),

            //form number : 58
            'online_service_order_form'             => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Online Service Order Form',
                'is_pro'     => false,
                'brief'      => 'This form can be used to create an online service order. (Payment Module is required)',
                'category'   => "Product",
                'tag'        => ["Order", "service", "online help", "handyman", "payment"],
                'json'       => '[{"id":"204","title":"Service Order Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[],"label_placement":"top"},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name","maxlength":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"Middle Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_15924974034200.26712438122064186"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_15924974402130.012591725433457768"},{"index":1,"element":"container","attributes":[],"settings":{"container_class":""},"columns":[{"fields":[{"index":8,"element":"multi_payment_component","attributes":{"type":"radio","name":"payment_input","value":""},"settings":{"container_class":"","label":"Choose Service","admin_field_label":"Product","label_placement":"","display_type":"","help_message":"","is_payment_field":"yes","pricing_options":[{"label":"Service Item 1 - $10\/hour","value":10,"image":""},{"label":"Service Item 2 - $19\/hour","value":"19"},{"label":"Service Item 3- $29\/hour","value":"29"}],"price_label":"Price:","enable_quantity":false,"enable_image_input":false,"is_element_lock":false,"layout_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Payment Field","icon_class":"ff-edit-shopping-cart","element":"input-radio","template":"inputMultiPayment"},"uniqElKey":"el_1592502076962"}]},{"fields":[{"index":6,"element":"item_quantity_component","attributes":{"type":"number","name":"item-quantity","value":"1","id":"","class":"","placeholder":"Hours","data-quantity_item":"yes"},"settings":{"container_class":"","is_payment_field":"yes","label":"How Many Hours?","admin_field_label":"Hours","label_placement":"","help_message":"","number_step":"","prefix_label":"","suffix_label":"","target_product":"payment_input","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"1","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Item Quantity","icon_class":"ff-edit-keyboard-o","template":"inputText"},"uniqElKey":"el_15925020855320.9400112640060003"}]}],"editor_options":{"title":"Two Column Container","icon_class":"ff-edit-column-2"},"uniqElKey":"el_15925020745170.6041197871212416"},{"index":10,"element":"payment_method","attributes":{"name":"payment_method","type":"radio","value":""},"settings":{"container_class":"","label":"Choose Payment Method","default_method":"","label_placement":"","help_message":"","payment_methods":{"stripe":{"title":"Credit\/Debit Card (Stripe)","enabled":"yes","method_value":"stripe","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with Card (Stripe)","label":"Method Label"},"require_billing_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Billing info"},"require_shipping_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Collect Shipping Info"}}},"paypal":{"title":"PayPal","enabled":"yes","method_value":"paypal","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with PayPal","label":"Method Label"},"require_shipping_address":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Shipping Address"}}},"test":{"title":"Offline Payment","enabled":"yes","method_value":"test","settings":{"option_label":{"type":"text","template":"inputText","value":"Test Payment","label":"Method Label"}}}},"admin_field_label":"","conditional_logics":[]},"editor_options":{"title":"Payment Method Field","icon_class":"ff-edit-credit-card","template":"inputPaymentMethods"},"uniqElKey":"el_15924975611200.8035560583323771"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Purchase {payment_total}","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"1","type":"form","conditions":null,"created_by":"1","created_at":"2020-06-18 23:40:30","updated_at":"2020-06-18 23:44:57","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<p>Thank you for your order<\/p> <p>{payment.receipt}<\/p>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"New Order Notification to Admin\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<h4>Order Items<\/h4> <p>{payment.order_items}<\/p> <h4>Other Data:<\/h4> <p>{all_data}<\/p> <p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"step_data_persistency_status","value":"no"},{"meta_key":"_payment_settings","value":"{\"currency\":\"USD\",\"push_meta_to_stripe\":\"no\",\"receipt_email\":\"email\",\"transaction_type\":\"product\",\"stripe_checkout_methods\":[\"card\"],\"stripe_meta_data\":[{\"item_value\":\"\",\"label\":\"\"}]}"},{"meta_key":"notifications","value":"{\"name\":\"Email To Customer\",\"sendTo\":{\"type\":\"field\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] Your Order Receipt\",\"message\":\"<p>{payment.receipt}<\/p> <p>Thank you<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"advancedValidationSettings","value":"{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}"},{"meta_key":"report_data_migrated","value":"\"yes\""}]}]'
            ),

            //form number : 60
            'payment_donation_form'                 => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Online Donation Form',
                'is_pro'     => true,
                'brief'      => 'This form can be used to create a service request. (Payment Module is required)',
                'category'   => "Product",
                'tag'        => ["Order", "service", "online help", "donation", "support", 'donation', "payment"],
                'json'       => '[{"id":"206","title":"Donation Form","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[],"label_placement":"top"},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name","maxlength":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"Middle Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_15925024747330.600432137734858"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_15925024795800.5874464366027161"},{"index":1,"element":"container","attributes":[],"settings":{"container_class":""},"columns":[{"fields":[{"index":8,"element":"multi_payment_component","attributes":{"type":"radio","name":"payment_input","value":""},"settings":{"container_class":"","label":"Donation Amount","admin_field_label":"","label_placement":"","display_type":"","help_message":"","is_payment_field":"yes","pricing_options":[{"label":"$20","value":"20","image":""},{"label":"$30","value":"30"},{"label":"$40","value":"50"},{"label":"Other","value":"0"}],"price_label":"Price:","enable_quantity":false,"enable_image_input":false,"is_element_lock":false,"layout_class":"ff_list_buttons","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Payment Field","icon_class":"ff-edit-shopping-cart","element":"input-radio","template":"inputMultiPayment"},"uniqElKey":"el_1592502662187"}]},{"fields":[{"index":6,"element":"custom_payment_component","attributes":{"type":"number","name":"custom-payment-amount","value":"","id":"","class":"","placeholder":"Please input your amount","data-payment_item":"yes"},"settings":{"container_class":"","is_payment_field":"yes","label":"Please Provide Custom Amount","admin_field_label":"","label_placement":"","help_message":"","number_step":"","prefix_label":"","suffix_label":"","validation_rules":{"required":{"value":true,"message":"Donation Amount is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"1","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"payment_input","value":"Other","operator":"="}]},"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Custom Payment Amount","icon_class":"ff-edit-keyboard-o","template":"inputText"},"uniqElKey":"el_1592502665775"}]}],"editor_options":{"title":"Two Column Container","icon_class":"ff-edit-column-2"},"uniqElKey":"el_15925026583450.5880630376189451"},{"index":10,"element":"payment_method","attributes":{"name":"payment_method","type":"radio","value":""},"settings":{"container_class":"","label":"Choose Payment Method","default_method":"","label_placement":"","help_message":"","payment_methods":{"stripe":{"title":"Credit\/Debit Card (Stripe)","enabled":"yes","method_value":"stripe","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with Card (Stripe)","label":"Method Label"},"require_billing_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Billing info"},"require_shipping_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Collect Shipping Info"}}},"paypal":{"title":"PayPal","enabled":"yes","method_value":"paypal","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with PayPal","label":"Method Label"},"require_shipping_address":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Shipping Address"}}},"test":{"title":"Offline Payment","enabled":"yes","method_value":"test","settings":{"option_label":{"type":"text","template":"inputText","value":"Offline Payment","label":"Method Label"}}}},"admin_field_label":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Payment Method Field","icon_class":"ff-edit-credit-card","template":"inputPaymentMethods"},"uniqElKey":"el_15925026721370.24223713945247938"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Donate Now {payment_total}","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"1","type":"form","conditions":null,"created_by":"1","created_at":"2020-06-18 23:47:51","updated_at":"2020-06-18 23:52:05","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<p>Thank you for your donation. Here is the donation details<\\\/p>\\n<p>{payment.receipt}<\\\/p>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"New Donation By {inputs.names} - {payment.payment_total}\",\"message\":\"<p>New Donation has been made by {inputs.names}.<\/p>\\n<p>{payment.receipt}<\/p>\\n<h3>Other Data:<\/h3>\\n<p>{all_data}<\/p>\\n<p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"step_data_persistency_status","value":"no"},{"meta_key":"advancedValidationSettings","value":"{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}"},{"meta_key":"_payment_settings","value":"{\"currency\":\"USD\",\"push_meta_to_stripe\":\"no\",\"receipt_email\":\"email\",\"transaction_type\":\"donation\",\"stripe_checkout_methods\":[\"card\"],\"stripe_meta_data\":[{\"item_value\":\"\",\"label\":\"\"}]}"},{"meta_key":"notifications","value":"{\"name\":\"Email To Donar\",\"sendTo\":{\"type\":\"field\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"Thank you for your Donarion - {payment.payment_total}\",\"message\":\"<p>Hello {inputs.names},<\/p>\\n<p>Thank you for your donation. Here is the donation details:<\/p>\\n<p>{payment.receipt}<\/p>\\n<h3>Other Data:<\/h3>\\n<p>{all_data}<\/p>\\n<p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"}]}]'
            ),


            //form number : 61
            'order_bump_form'                       => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Order Bump Example Form',
                'is_pro'     => true,
                'brief'      => 'Example how you can create order bump form. (Payment Module is required)',
                'category'   => "Product",
                'tag'        => ["Online order", "shirt order", "product order", "payment"],
                'json'       => '[{"id":"209","title":"Order Bump Form with Fluent Forms","status":"published","appearance_settings":null,"form_fields":{"fields":[{"index":1,"element":"container","attributes":[],"settings":{"container_class":""},"columns":[{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[],"label_placement":"top"},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name","maxlength":""},"settings":{"container_class":"","label":"Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"Middle Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false,"maxlength":""},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_15906683422410.5133349422787035"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[],"is_unique":"no","unique_validation_message":"Email address need to be unique."},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_15906683351580.9543681646809019"}]}],"editor_options":{"title":"Two Column Container","icon_class":"ff-edit-column-2"},"uniqElKey":"el_15906683245510.7830044830042453"},{"index":8,"element":"multi_payment_component","attributes":{"type":"single","name":"payment_input","value":"49"},"settings":{"container_class":"","label":"Your Awesome product","admin_field_label":"","label_placement":"","display_type":"","help_message":"","is_payment_field":"yes","pricing_options":[{"label":"Payment Item 1","value":10,"image":""}],"price_label":"Price:","enable_quantity":false,"enable_image_input":false,"is_element_lock":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Payment Field","icon_class":"ff-edit-shopping-cart","element":"input-radio","template":"inputMultiPayment"},"uniqElKey":"el_1590668351796"},{"index":10,"element":"payment_method","attributes":{"name":"payment_method","type":"radio","value":""},"settings":{"container_class":"","label":"Payment Method","default_method":"","label_placement":"","help_message":"","payment_methods":{"stripe":{"title":"Credit\/Debit Card (Stripe)","enabled":"yes","method_value":"stripe","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with Card (Stripe)","label":"Method Label"},"require_billing_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Billing info"},"require_shipping_info":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Collect Shipping Info"}}},"paypal":{"title":"PayPal","enabled":"yes","method_value":"paypal","settings":{"option_label":{"type":"text","template":"inputText","value":"Pay with PayPal","label":"Method Label"},"require_shipping_address":{"type":"checkbox","template":"inputYesNoCheckbox","value":"no","label":"Require Shipping Address"}}},"test":{"title":"Test Payment","enabled":"yes","method_value":"test","settings":{"option_label":{"type":"text","template":"inputText","value":"Test Payment","label":"Method Label"}}}},"admin_field_label":"","conditional_logics":[]},"editor_options":{"title":"Payment Method Field","icon_class":"ff-edit-credit-card","template":"inputPaymentMethods"},"uniqElKey":"el_1590667729771"},{"index":1,"element":"container","attributes":[],"settings":{"container_class":"highlight_upsell"},"columns":[{"fields":[{"index":8,"element":"multi_payment_component","attributes":{"type":"checkbox","name":"payment_input_1","value":""},"settings":{"container_class":"ff_high_center","label":"Payment Item","admin_field_label":"","label_placement":"hide_label","display_type":"","help_message":"","is_payment_field":"yes","pricing_options":[{"label":"Yes, I want access only $19 Extra","value":"29","image":""}],"price_label":"Price:","enable_quantity":false,"enable_image_input":false,"is_element_lock":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Payment Field","icon_class":"ff-edit-shopping-cart","element":"input-radio","template":"inputMultiPayment"},"uniqElKey":"el_1590667787762"},{"index":20,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"margin: 0;\"><span style=\"text-decoration: underline;\"><strong>One time offer:<\/strong><\/span> I would also like get over-the-shulder videos that walk me through every single steps of the passive profits system for only $19 extra (a $97 value)<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"container_class":""},"editor_options":{"title":"Custom HTML","icon_class":"ff-edit-html","template":"customHTML"},"uniqElKey":"el_15906677914400.3394559374440802"}]}],"editor_options":{"title":"One Column Container","icon_class":"dashicons dashicons-align-center"},"uniqElKey":"el_15906677855230.32567666841505627"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"center","button_style":"orange","container_class":"","help_message":"","background_color":"#E6A23C","button_size":"lg","color":"#ffffff","button_ui":{"type":"default","text":"Purchase Now {payment_total}","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"1","type":"form","conditions":null,"created_by":"1","created_at":null,"updated_at":null,"metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<p>Thank you for your purchase<\\\/p>\\n<p>{payment.receipt}<\\\/p>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-left\"},\"delete_entry_on_submission\":\"no\",\"id\":\"452\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"Email to Site Admin\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"New Payment has been made by {inputs.names} - {payment.payment_total}\",\"message\":\"<p>{payment.receipt}<\/p>\\n<p>This form submitted at: {embed_post.permalink}<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"},{"meta_key":"_custom_form_css","value":".highlight_upsell {\n    padding: 10px 20px 0px;\n    border: 4px dashed gray;\n    margin-bottom: 20px;\n    background: #fffce0;\n}\n\n.highlight_upsell .ff-el-group {\n    margin-bottom: 0px;\n}\n\n.ff_high_center {\n    background: #fff385;\n    padding: 10px 20px;\n    text-align: center;\n}\n\n.ff_high_center label {\n    color: green;\n    font-weight: bolder;\n    font-size: 18px;\n}"},{"meta_key":"_custom_form_js","value":""},{"meta_key":"advancedValidationSettings","value":"{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}"},{"meta_key":"_payment_settings","value":"{\"currency\":\"USD\",\"push_meta_to_stripe\":\"no\",\"receipt_email\":\"email\",\"transaction_type\":\"product\",\"stripe_checkout_methods\":[\"card\"],\"stripe_meta_data\":[{\"item_value\":\"\",\"label\":\"\"}]}"},{"meta_key":"notifications","value":"{\"name\":\"Email To Customer\",\"sendTo\":{\"type\":\"field\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"Thank you for Payment - {payment.payment_total}\",\"message\":\"<p>{payment.receipt}<\/p>\\n<p>&nbsp;<\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\",\"attachments\":[],\"pdf_attachments\":[]}"}]}]'
            ),

            //form number : 62
            'student_survey_form'                   => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Student Survey Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to do a student survey.',
                'category'   => "Education",
                'tag'        => ["Survey", "student survey", "online survey"],
                'json'       => '[{"id":"62","title":"Student Survey Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Your First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Your Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570681468957"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Your Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570681471575"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h3>How important is it that we provide you with the following?<\/h3>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570681554354"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Variety of student organizations ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not important at all":"Not important at all","Somewhat important":"Somewhat important","Very Important":"Very Important","Essential":"Essential"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570681716842"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Plenty of professor office hours","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not important at all":"Not important at all","Somewhat important":"Somewhat important","Very Important":"Very Important","Essential":"Essential"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570681806289"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"A global perspective","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not important at all":"Not important at all","Somewhat important":"Somewhat important","Very Important":"Very Important","Essential":"Essential"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570681817431"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_3","value":""},"settings":{"container_class":"","label":"Internship opportunities","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not important at all":"Not important at all","Somewhat important":"Somewhat important","Very Important":"Very Important","Essential":"Essential"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570681830625"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570682052340"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h3>How important is it that we provide you with the following?<\/h3>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570682078971"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_4","value":""},"settings":{"container_class":"","label":"Get a job to help pay for college expenses","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not at all likely\t":"Not at all likely\t","Somewhat likely\t":"Somewhat likely\t","Very Likely":"Very Likely"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570682075715"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_5","value":""},"settings":{"container_class":"","label":"Become a teacher assistant\t","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not at all likely\t":"Not at all likely\t","Somewhat likely\t":"Somewhat likely\t","Very Likely":"Very Likely"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570682121382"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_6","value":""},"settings":{"container_class":"","label":"Study abroad\t","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not at all likely\t":"Not at all likely\t","Somewhat likely\t":"Somewhat likely\t","Very Likely":"Very Likely"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570682123066"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_7","value":""},"settings":{"container_class":"","label":"Take out student loans","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Not at all likely\t":"Not at all likely\t","Somewhat likely\t":"Somewhat likely\t","Very Likely":"Very Likely"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570682145405"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Please select any activities\/groups you plan on participating in while in school.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Intramural Sports":"Intramural Sports","Student Organizations":"Student Organizations","Fraternity\/Sorority":"Fraternity\/Sorority","Other":"Other"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570682180538"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"others","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Other","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570682234942"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button", "attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 63
            'classroom_observation_form'            => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Classroom Observation Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to do a classroom observation.',
                'category'   => "Education",
                'tag'        => ["Online survey", "education", "classroom"],
                'json'       => '[{"id":"63","title":"Classroom Observation Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<div  style=\"text-align: center;\">\n<h3>Classroom Observation<\/h3>\nPlease use the following form to evaluate the teachers performance in the classroom. Your feedback is valuable and helps us ensure success for all teachers and students. Please answer each question honestly.\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570682627458"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Teacher\'s Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Teacher\'s Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570682726941"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Classroom\/Course","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570682786996"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Observation Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570682791895"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570682808710"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Please rate the teacher\'s performance in the following areas:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required","per_row":true}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"grid_columns":{"Strongly Agree\t":"Strongly Agree\t","Agree":"Agree","Neutral":"Neutral","Disagree":"Disagree","Strongly Disagree":"Strongly Disagree"},"grid_rows":{"Teacher was prepared for the lesson.\t":"Teacher was prepared for the lesson.\t","Teacher encouraged student participation.\t":"Teacher encouraged student participation.\t","Teacher explained the lesson thoroughly.\t":"Teacher explained the lesson thoroughly.\t","Teacher interacted with all students.\t":"Teacher interacted with all students.\t","Teacher was able to control the entire classroom.\t":"Teacher was able to control the entire classroom.\t","Teacher effectively used technology.\t":"Teacher effectively used technology.\t","Teacher used time efficiently.\t":"Teacher used time efficiently.\t","Teacher responded appropriately to student questions.\t":"Teacher responded appropriately to student questions.\t","Teacher used a variety of teaching methods.\t":"Teacher used a variety of teaching methods.\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570689026920"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570683045855"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_9","value":""},"settings":{"container_class":"","label":"Based on this observation, would you pass or fail this teacher?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Pass":"Pass","Fail":"Fail"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570683067552"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Additional Comments","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570683116056"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p><strong><span id=\"label42633724\" class=\"fsLabel\">Oberserver\'s Details (Optional)<\/span><\/strong><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570683153616"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570683173183"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"right","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Evalution","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false, "message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 64
            'client_satisfaction_survey_form'       => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Client Satisfaction Survey Form',
                'is_pro'     => false,
                'brief'      => 'You can use this to perform a client satisfaction survey form',
                'category'   => "Marketing",
                'tag'        => ["Marketing", "survey", "satisfaction"],
                'json'       => '[{"id":"64","title":"Client Satisfaction Survey Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Client Satisfaction Survey","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570682763978"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Which product did you purchase?","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Office Accessories ":"Office Accessories ","Home appliance ":"Home appliance ","Digital Product":"Digital Product","Garage Hardware":"Garage Hardware"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570682798953"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What was your primary reason for purchasing the product?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570682852522"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"What three features are most important to you?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Custom responses":"Custom responses","Custom integrations":"Custom integrations","Expanded functionality":"Expanded functionality","Easy to navigate":"Easy to navigate","Offline capabilities":"Offline capabilities"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570682873089"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"How can we improve our products\/services?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570682943938"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Would you use our product \/ service in the future?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"Definitely":"Definitely","Probably":"Probably","Not Sure":"Not Sure","Probably Not":"Probably Not"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570682967577"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{"backgroundColor":"rgba(126, 173, 79, 1)"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 67
            'customer_complaint_form'               => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Customer Complaint Form',
                'is_pro'     => false,
                'brief'      => 'Use this form to crete a customer complaint from.',
                'category'   => "Marketing",
                'tag'        => ["Marketing", "customer complain", "customer feedback"],
                'json'       => '[{"id":"67","title":"Customer Complaint Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Customer Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570683983321"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570683568392"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Product Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570698648236"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Product ID","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570698660319"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570698540497"}]},{"fields":[{"index":5,"element":"select_country","attributes":{"name":"country-list","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Country","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"US":"United States of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-globe","template":"selectCountry"},"uniqElKey":"el_1570683722526"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Zip Code","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570698634098"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570698522369"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570698459932"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570683671991"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570698501610"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Complaint Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570683794847"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Complaint Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570683817559"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Complaint Details:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570683846055"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"",
                    "label":"What action needs to be taken to resolve this issue?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570683866743"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{"backgroundColor":"rgba(19, 184, 203, 1)","color":"#F4EDED"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 68
            'course_evaluation_survey_form'         => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Course Evaluation Survey form',
                'is_pro'     => true,
                'brief'      => 'You can use this from to perform the course evaluation survey.',
                'category'   => "Education",
                'tag'        => ["Course evaluation", "teacher assessment"],
                'json'       => '[{"id":"68","title":"Course Evaluation Survey form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<div class=\"fsSection fs1Col\">\n<div id=\"fsRow2380722-1\" class=\"fsRow fsFieldRow fsLastRow\">\n<div id=\"fsCell42867454\" class=\"fsRowBody fsCell fsFieldCell fsFirst fsLast fsLabelVertical fsSpan100\" lang=\"en\">\n<p>1. Please answer all required questions.<\/p>\n<p>2. Only complete this evaluation if you will be completing the course.<\/p>\n<\/div>\n<\/div>\n<\/div>\n<div id=\"fsSection42867455\" class=\"fsSection fs1Col\">\n<div class=\"fsSectionHeader\">\n<h2 class=\"fsSectionHeading\">Course Data:<\/h2>\n<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570683714640"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Course Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570683740768"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Course Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570683755077"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Section Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570683779956"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Instructor Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570683742700"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570683838706"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Evaluation","description":"<p>Your Evalutionsare important so do it carefully<\/p>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 293px; top: 38px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570683867069"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Level of effort you put into the course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570683921870"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Your level of knowledge at the beginning of course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570683969337"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Your level of knowledge at the end of course.\t","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570683985928"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_4","value":""},"settings":{"container_class":"","label":"I understood the objectives of the course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Strongly Agree":"Strongly Agree","Agree":"Agree","Neutral":"Neutral","Disagree":"Disagree","Strongly Disagree":"Strongly Disagree"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684064895"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_9","value":""},"settings":{"container_class":"","label":"The length of the course was appropriate to cover content.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Strongly Agree":"Strongly Agree","Agree":"Agree","Neutral":"Neutral","Disagree":"Disagree","Strongly Disagree":"Strongly Disagree"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684312850"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_5","value":""},"settings":{"container_class":"","label":"The course provided me with new information.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Strongly Agree":"Strongly Agree","Agree":"Agree","Neutral":"Neutral","Disagree":"Disagree","Strongly Disagree":"Strongly Disagree"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684075830"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684089759"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_10","value":""},"settings":{"container_class":"","label":"Instructor\'s preparation.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684446524"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_11","value":""},"settings":{"container_class":"","label":"Instructor\'s deliverance ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684465079"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_12","value":""},"settings":{"container_class":"","label":"Instructor\'s communication.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},
                "options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684473777"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_13","value":""},"settings":{"container_class":"","label":"Instructor\'s effectiveness.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684488290"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_14","value":""},"settings":{"container_class":"","label":"Instructor\'s availability.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684497957"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_15","value":""},"settings":{"container_class":"","label":"Overall quality of the course","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684531092"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_16","value":""},"settings":{"container_class":"","label":"Overall quality of the equipment used for the course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684546492"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_17","value":""},"settings":{"container_class":"","label":"Overall quality of the course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Very Good\t":"Very Good\t","Good":"Good","Fair":"Fair","Poor":"Poor","Very Poor":"Very Poor"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684556880"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684578369"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_18","value":""},"settings":{"container_class":"","label":"Would you recommend this course to other students?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684586872"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_19","value":""},"settings":{"container_class":"","label":"Why you chose this course.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Degree requirement":"Degree requirement","Time offered":"Time offered","Interest":"Interest"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684611685"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_20","value":""},"settings":{"container_class":"","label":"Your class standing.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Freshman":"Freshman","Sophomore":"Sophomore","Junior":"Junior","Senior":"Senior","Graduate":"Graduate"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684653872"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684731629"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Please identify aspects of the course you found useful.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684751423"}]},{"fields":[{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Please provide any suggestions to improve the course.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684758119"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570684746154"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 70
            'market_research_survey_form'           => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Market Research Survey Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to a market research.',
                'category'   => "Marketing",
                'tag'        => ["Market research", "marketing", "online survey"],
                'json'       => '[{"id":"70","title":"Market Research Survey Form","form":{"fields":[{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"How often do you use our product?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"More than once a week":"More than once a week","Once a week":"Once a week","Monthly":"Monthly","Every other month":"Every other month","A few times a year":"A few times a year"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570684518054"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684370878"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What similar products do you use? (by name and brand)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684600189"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684374734"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"When did you last purchase our product?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Less than 1 month ago":"Less than 1 month ago","Between 1 month and 6 months ago":"Between 1 month and 6 months ago","Between 6 months and 1 year ago":"Between 6 months and 1 year ago","More than one year ago":"More than one year ago","I don\'t remember":"I don\'t remember"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570684644101"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684773438"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Have you had a chance to review our newest product?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570684780085"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684802008"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What do you think of our new product?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684812950"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What is your least favorite thing about our new product?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684817781"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684889192"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_2","value":[]},"settings":{"container_class":"","label":"How do you feel our products pricing compares with other similar products?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Less expensive":"Less expensive","About the same price":"About the same price","More expensive":"More expensive"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570684895517"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570684949903"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Tell us a little about yourself.","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570684992645"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_3","value":[]},"settings":{"container_class":"","label":"What is your age range?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"18 or younger":"18 or younger","19 - 24":"19 - 24","25 - 34":"25 - 34","35 - 44":"35 - 44","45 - 54":"45 - 54","55 or older":"55 or older"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570685017517"},{"index":5,"element":"select_country","attributes":{"name":"country-list","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What country are you from?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"US":"United States of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-globe","template":"selectCountry"},"uniqElKey":"el_1570685115869"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 71
            'database_management_help request_from' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Database Management Help Request from',
                'is_pro'     => true,
                'brief'      => 'Use this form to seek help form the tech support; for example, the database management help.',
                'category'   => "Marketing",
                'tag'        => ["Marketing", "online help", "support help"],
                'json'       => '[{"id":"71","title":"Database Management Help Request from","form":{"fields":[{"index":2,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"First Name field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1516797564818"},{"index":7,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"you@domain.com"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Email field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1516797583697"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570684406116"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570699970556"},{"index":2,"element":"textarea","attributes":{"name":"message","value":"","id":"","class":"","placeholder":"Type your message here...","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe your current issues\/needs","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Message field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1516797589062"},{"index":2,"element":"textarea","attributes":{"name":"message_1","value":"","id":"","class":"","placeholder":"Type your message here...","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe your current system if applicable.","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Message field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570684428634"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"What is your expertise with managing your database?","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Novice":"Novice","Intermediate":"Intermediate","Expert":"Expert"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570684515448"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Do you need an intranet in your office?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570684585832"},{"index":7,"element":"select","attributes":{"name":"dropdown_1","value":"","id":"","class":""},"settings":{"label":"Software Type","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Accounting and Financial Management":"Accounting and Financial Management","Asset Management":"Asset Management"," Business Intelligence and Data Management Customer":" Business Intelligence and Data Management Customer"," Relationship Management (CRM)":" Relationship Management (CRM)"," Enterprise Resource Planning (ERP)":" Enterprise Resource Planning (ERP)"," Human Capital Management (HCM)":" Human Capital Management (HCM)"," Information Management and Collaboration":" Information Management and Collaboration"," Product Lifecycle Management (PLM) ":" Product Lifecycle Management (PLM) "," Project and Process Management":" Project and Process Management","   Supply Chain Management (SCM)":"   Supply Chain Management (SCM)"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570684631918"},{"index":7,"element":"select","attributes":{"name":"dropdown_2","value":"","id":"","class":""},"settings":{"label":"Business Area","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Sales and Marketing":"Sales and Marketing","Professional Services and Support":"Professional Services and Support","Production and Distribution":"Production and Distribution","IT Management and Development":"IT Management and Development","Data Management and Analysis":"Data Management and Analysis",
                    "Back Office and Operations":"Back Office and Operations"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570685212508"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Needed Requirements, Functionality, or Specification","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570685794700"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Desired deliverables","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570685817491"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"When do you need the support?","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570685921417"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_6","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What is your budget?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685887742"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Will this system be sold as third party software?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570685925016"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_2","value":[]},"settings":{"container_class":"","label":"Will you need back up services?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570685980359"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_3","value":[]},"settings":{"container_class":"","label":"Will you need virus protection?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570685993577"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Upload any supporting documents.","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":["pdf","jpg|jpeg|gif|png|bmp"],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570686018986"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 72
            'university_enrollment_form'            => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'University Enrollment Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to do the university enrollment for a studnet.',
                'category'   => "Education",
                'tag'        => ["Education", "university", "enrollment"],
                'json'       => '[{"id":"72","title":"University Enrollment Form","form":{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Anticipated Start Date","admin_field_label":"","label_placement":"","date_format":"d.m.Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570684989530"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570685021902"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570685042448"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570685046783"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of Birth","admin_field_label":"","label_placement":"","date_format":"d.m.Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570700188161"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Gender","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"Male":"Male","Female":"Female","Others":"Others"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570700192033"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570685050447"},{"index":15,"element":"input_image","attributes":{"type":"file","name":"image-upload","value":"","id":"","class":"","accept":"image\/*"},"settings":{"container_class":"","label":"Proof of identity (e.g. birth certificate, Passport etc.)","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_image_types":{"value":["jpg|jpeg","png","gif"],"message":"Allowed image size does not match"}},"conditional_logics":[]},"editor_options":{"title":"Image Upload","icon_class":"icon-picture-o","template":"inputFile"},"uniqElKey":"el_1570685249394"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Background Information:","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570685313901"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Enrollment Status","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Full Time":"Full Time","Part Time":"Part Time"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570685354734"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"High School Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685422648"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"High School Address*","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"",
                    "label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570685418979"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"GPA","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685436187"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Diploma Type","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685454020"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"High School Transcripts","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":["doc|ppt|pps|xls|mdb|docx|xlsx|pptx|odt|odp|ods|odg|odc|odb|odf|rtf|txt","pdf","zip|gz|gzip|rar|7z","jpg|jpeg|gif|png|bmp"],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570685480739"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Medical Allergies","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685516179"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Parent\/Guardian Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Parent\/Guardian (First Name)","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"(Last Name)","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570685540179"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_5","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Parent\/Guardian Company","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685621269"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Parent\/Guardian Phone","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570685638725"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Parent\/Guardian Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570685654167"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 74
            'volunteer_signup_form'                 => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Volunteer sign up form',
                'is_pro'     => false,
                'brief'      => 'Use this form to do the volunteer sign up',
                'category'   => "Nonprofit",
                'tag'        => ["Non Profit", "volunteer", "help", "humanity"],
                'json'       => '[{"id":"74","title":"Volunteer sign up form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Volunteer Sign Up","description":"<div id=\"fsSection83427461\" class=\"fsSection fs1Col\">\n<div id=\"fsRow3617571-3\" class=\"fsRow fsFieldRow fsLastRow\">\n<div id=\"fsCell83427463\" class=\"fsRowBody fsCell fsFieldCell fsFirst fsLast fsLabelVertical fsSpan100\" lang=\"en\">\n<p class=\"fsSectionText\">Come with us and help out your local community!<\/p>\n<\/div>\n<\/div>\n<\/div>\n<div id=\"fsSection83427464\" class=\"fsSection fs1Col\">\u00a0<\/div>","align":"center","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570685851381"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Where would you like to volunteer (Check any that apply)","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Food bank":"Food bank","Animal shelter":"Animal shelter","Preschool":"Preschool","City lawn care":"City lawn care","Community Service":"Community Service"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570685921940"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"How many hours a week can you dedicate?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570685965867"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"When are you available to start?","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570686157250"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570686018387"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Permanent Address ","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570686031467"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570686088371"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570686107211"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570686084163"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{"backgroundColor":"rgba(85, 66, 66, 1)","color":"#F2EBEB"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 76
            'donation_form'                         => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Donation Form',
                'is_pro'     => false,
                'brief'      => 'To create the donation request form, you can use this',
                'category'   => "Nonprofit",
                'tag'        => ["Non Profit", "donation", "help", "humanity"],
                'json'       => '[{"id":"76","title":"Donation Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>Fillup this form to add to our doner list.\u00a0<\/strong><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570686622963"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570686731683"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570686773473"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570686777497"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570700704044"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Your Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700718461"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":"e.g.: $10"},"settings":{"container_class":"","label":"Amount you would like to donate","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570686956274"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Your Preferred Method of Donation","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Credit Card":"Credit Card","PayPal":"PayPal","CashApp":"CashApp","Wire Transfer":"Wire Transfer","Check":"Check"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570700560368"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"How repeatedly do you want to donate?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"One Time":"One Time","Yearly":"Yearly","Monthly":"Monthly","Weekly":"Weekly","Daily":"Daily"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570700624445"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 78
            'graphic_designer_contact_form'         => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Graphic Designer Contact Form',
                'is_pro'     => false,
                'brief'      => 'You can use this form to create a form that can be used to request a professional service',
                'category'   => "IT",
                'tag'        => ["IT", "tech", "designer", "graphic"],
                'json'       => '[{"id":"78","title":"Graphic Designer Contact Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"What can I help you with?","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570686619180"},{"index":2,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"First Name field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1516797564818"},{"index":7,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"you@domain.com"},"settings":{"container_class":"","label":"Your Email","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Email field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1516797583697"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570687399112"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"When is the best time to contact you?","admin_field_label":"","label_placement":"","date_format":"h:i K","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701154762"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"When is the best date to contact you?","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570687461730"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"What can I help you with?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Social Media Publication":"Social Media Publication","Prints & Ilustrations":"Prints & Ilustrations","Website Design":"Website Design","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570687540354"},{"index":2,"element":"textarea","attributes":{"name":"message","value":"","id":"","class":"","placeholder":"Type your message here...","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe your need","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Message field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1516797589062"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"When do you need the graphic designer?","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701063541"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 79
            'multi_file_upload_form'                => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Multi file upload form',
                'is_pro'     => true,
                'brief'      => 'You can use this form to create a form for multiple upload.',
                'category'   => "IT",
                'tag'        => ["It", "education", "file upload"],
                'json'       => '[{"id":"79","title":"Multi file upload form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570687268942"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570687293339"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"1","id":"","class":"","placeholder":"1-5"},"settings":{"container_class":"","label":"How many files do you need uploading?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"1","message":"Minimum value is "},"max":{"value":"10","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570687439535"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"File Upload","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"numeric-field","value":"1","operator":">="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570687472221"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_1","value":"","id":"","class":""},"settings":{"container_class":"","label":"File Upload","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"numeric-field","value":"2","operator":">="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570687474449"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_2","value":"","id":"","class":""},"settings":{"container_class":"","label":"File Upload","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"numeric-field","value":"3","operator":">="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570687504965"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_3","value":"","id":"","class":""},"settings":{"container_class":"","label":"File Upload","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"numeric-field","value":"4","operator":">="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570687516403"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_4","value":"","id":"","class":""},"settings":{"container_class":"","label":"File Upload","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"numeric-field","value":"5","operator":">="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570687530792"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Additional Comments","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570687595629"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 81
            'highschool_transcript_request_from'    => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'High School Transcript Request From',
                'is_pro'     => true,
                'brief'      => 'Use this form to request the school documents.',
                'category'   => "Education",
                'tag'        => ["Education", "school", "request"],
                'json'       => '[{"id":"81","title":"High School Transcript Request From","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570688098700"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Graduation Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570688194088"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570688217102"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Registration Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688229288"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Birthdate","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570688245763"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Current Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570688265645"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570688289864"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"I wish to pick up an UNOFFICIAL copy of my transcript","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570688311786"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Please send an OFFICIAL copy of my high school transcript to:","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570688417395"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"College\/University Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688445375"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570688471703"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570688478486"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"<p>College\/University info<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570688542307"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"College\/University Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688579789"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address3","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570688596943"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570688603366"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570688618403"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Today\'s Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570688644312"},{"index":15,"element":"input_image","attributes":{"type":"file","name":"image-upload","value":"","id":"","class":"","accept":"image\/*"},"settings":{"container_class":"","label":"Upload Signature","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_image_types":{"value":["jpg|jpeg","png","gif"],"message":"Allowed image size does not match"}},"conditional_logics":[]},"editor_options":{"title":"Image Upload","icon_class":"icon-picture-o","template":"inputFile"},"uniqElKey":"el_1570688683654"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 82
            'partnership_application_form'          => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Partnership application form',
                'is_pro'     => true,
                'brief'      => 'This form can be used to create a form for patrnership agreement.',
                'category'   => "Finance",
                'tag'        => ["HR", "Finance", "IT", "Partnership", "application"],
                'json'       => '[{"id":"82","title":"Partnership application form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Partnership Application Form\t","description":"<p>Thank you for your interests in our company. We are excited to have you on board as one of our esteemed partners. To get started, please complete all fields accordingly. We will review and get in touch with your shortly. If you are unsure about any of the answers, please use an estimation.\u00a0<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570688772459"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688832461"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company URL","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688834783"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570688827205"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Number of Employees","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688832461"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Number of Customers","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570688834783"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570688872893"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Place of Business","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Singapore":"Singapore","Malaysia":"Malaysia","HongKong":"HongKong"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570688928851"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Current Demand Generation Activities (you can select more than one)","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Direct Mailer":"Direct Mailer","Website Optimization":"Website Optimization","Email\/Mobile Marketing":"Email\/Mobile Marketing","Media Advertisement":"Media Advertisement","Social Media":"Social Media","Paid Search \/ SEO":"Paid Search \/ SEO","Trade show\/Workshop":"Trade show\/Workshop"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570689033598"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570689288717"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Do you want us to publish your profile on our site?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570689328534"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Your Company Profile (less than 150 words)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570689365456"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Company Specialization Keywords (Separated by comma)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570689403621"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Sales Inquiry Number (Leave blank if unknown)","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570689431777"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Sales Enquiry Email Address","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570689472697"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570689428622"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Upload Logo (PNG, Transparent Background)","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570689521234"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570689550780"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2>Point of Contact - Partnership<\/h2>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570689580798"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_5","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Contact Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570689809823"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,
                    "message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570689883374"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email Address","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570689894280"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570689850530"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 83
            'employee_evaluation_form'              => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Employee Evaluation Form',
                'is_pro'     => true,
                'brief'      => 'This form can be used to do an employee.',
                'category'   => "HR",
                'tag'        => ["Evaluation", "HR", "office", "corporate"],
                'json'       => '[{"id":"83","title":"Employee Evaluation Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>Please remember that, the form will be confidential and will be used for only internally; so, feel free to submit your data however you feel to submit;\u00a0<\/strong><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570702175914"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570689782476"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Title","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570689820062"}]},{"fields":[{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Relationship with employee:","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Coworker":"Coworker","Supervisoe(Direct)":"Supervisoe(Direct)","Supervisoe(indirect)":"Supervisoe(indirect)"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570689833476"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570689816823"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<div class=\"c-title\">\n<h3>Employee Information<\/h3>\n<\/div>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 130px; top: 38px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570689925613"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570689939836"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Text Input","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570690142095"}]},{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Review type:","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"90-Day Review":"90-Day Review","Annual\/Raise Review":"Annual\/Raise Review"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570690153659"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570690139004"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"How would you rate the employee...","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Very Poor":"Very Poor","Poor":"Poor","Average":"Average","Good":"Good","Very Good":"Very Good"},"grid_rows":{"Attendance?\t":"Attendance?\t","Attire?":"Attire?","Professionalism?":"Professionalism?","Work area?":"Work area?","Ability to do the job?":"Ability to do the job?","Ability to work with others?\t":"Ability to work with others?\t","Ability to receive feedback\/criticism?\t":"Ability to receive feedback\/criticism?\t","Ability to adapt?":"Ability to adapt?","Willingness to learn?\t":"Willingness to learn?\t","Willingness to participate?":"Willingness to participate?","Work ethic?":"Work ethic?","Quality of work?":"Quality of work?"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570690219522"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What are the employee\'s top qualities?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570690459722"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"In what ways could the employee improve?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570690441275"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,
                    "pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 85
            'party_invite_form'                     => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Party Invite Form',
                'is_pro'     => true,
                'brief'      => 'For social invitation, you can use this form.',
                'category'   => "Social",
                'tag'        => ["Social", "party", "invite"],
                'json'       => '[{"id":"85","title":"Party Invite Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>You\'re Invited! <\/strong><\/p>\n<p style=\"text-align: center;\"><strong>Come get cool at our pool this 4th of July!<\/strong><\/p>\n<div style=\"width: 35%; margin: 0px auto; text-align: center;\">[You can add an Image\/Logo Here]<\/div>\n<p style=\"text-align: center;\">Time: July 4th 2020<\/p>\n<p style=\"text-align: center;\">Address: 2611 Ash Avenue, SAN DIEGO, CA, California, 92152\u00a0<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570690728985"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Are you coming?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570691339820"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Will you bring a guest with you?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570691365305"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Cool! How many? (maximum 3)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"3","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_1","value":"yes","operator":"="}]},"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570691383553"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Are you bringing any food? (e.g. wine, sandwich, pizza etc. )","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570691442090"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Cool! What are you bringing?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_2","value":"yes","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570691451487"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"sm","color":"#ffffff","button_ui":{"type":"default","text":"Submit","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 87
            'software_survey_form'                  => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Software Survey Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to create a software survey or a product survey.',
                'category'   => "IT",
                'tag'        => ["Software", "survey", "request", "office"],
                'json'       => '[{"id":"87","title":"Software Survey Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Software Survey","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570691364486"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"How did you hear about ...?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Our Website":"Our Website","Frineds":"Frineds","Social Media":"Social Media","Ads":"Ads","Generic Search":"Generic Search"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570691410457"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Which platform do you use?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Mac OS":"Mac OS","Linux":"Linux","Windows":"Windows","Other":"Other"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570691462708"},{"index":8,"element":"ratings","attributes":{"class":"","value":0,"name":"ratings"},"settings":{"label":"How would you rate our software?","show_text":false,"help_message":"","label_placement":"","admin_field_label":"","container_class":"","conditional_logics":[],"validation_rules":{"required":{"value":false,"message":"This field is required"}}},"options":{"1":"Nice","2":"Good","3":"Very Good","4":"Awesome","5":"Amazing"},"editor_options":{"title":"Ratings","icon_class":"icon-eye-slash","template":"ratings"},"uniqElKey":"el_1570691524650"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_2","value":[]},"settings":{"container_class":"","label":"Did you purchase any of our software?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570691587030"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Please let us know if you have any suggestions for us.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570691583718"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 88
            'hardware_request_form'                 => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Hardware Request Form',
                'is_pro'     => false,
                'brief'      => 'You can use this form to create a hardware request in your office.',
                'category'   => "IT",
                'tag'        => ["HR", "IT", "Hardware"],
                'json'       => '[{"id":"88","title":"Hardware Request Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Hardware Request Form","description":"<p style=\"text-align: left;\">This form will be used to request if any new hardware is needed in any department.\u00a0<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692575749"},{"index":2,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Requester\'s First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"First Name field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Requester\'s Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1516797564818"},{"index":7,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"you@domain.com"},"settings":{"container_class":"","label":"Requester\'s Email","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Email field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1516797583697"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Requester\'s Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570691864195"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Department to Purchase","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570691901415"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"What type of hardware do you need?","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"New Destop":"New Destop","New Laptop":"New Laptop","Tablet Computer":"Tablet Computer","Accessories ":"Accessories ","Others":"Others"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570691948417"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"If you choose other, please write the name.","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703018093"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Choose Software to to be pre installed ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Microsoft Office":"Microsoft Office","Adobe Products":"Adobe Products","3D Software":"3D Software"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570692048244"},{"index":2,"element":"textarea","attributes":{"name":"message","value":"","id":"","class":"","placeholder":"Type your message here...","rows":4,"cols":2},"settings":{"container_class":"","label":"Other Software \/ Instruction ","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Message field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1516797589062"},{"index":2,"element":"textarea","attributes":{"name":"message_1","value":"","id":"","class":"","placeholder":"Type your message here...","rows":4,"cols":2},"settings":{"container_class":"","label":"Reason for the Request (Be Specific)","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Message field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692289814"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date Submitted","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570692459185"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 89
            'functional_behavioral_assessment_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Functional Behavioral Assessment Form',
                'is_pro'     => true,
                'brief'      => 'This form can be used to perform a functional behavioral.',
                'category'   => "Education",
                'tag'        => ["Education", "Social", "behaviour"],
                'json'       => '[{"id":"89","title":"Functional Behavioral Assessment Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570691787066"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570691810024"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Sources of Data","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Record Review":"Record Review","Scatterplot":"Scatterplot","ABC Logs":"ABC Logs","Other":"Other"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570691825335"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe the data source","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Other","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570691891321"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Information Reported by:","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Teacher":"Teacher","Parent":"Parent","Student":"Student","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570691930433"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe your role.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570691982011"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Assessor Name ","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Assessor Name(First Name)","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Assessor Name(Last Name)","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570692022666"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Problem Behaviors","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692095297"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_6","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Describe behaviors in specific and observable terms.","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692282542"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_8","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Estimated frequency","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692305723"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_9","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Describe any observed patterns related to reported behavior.","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692329357"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Medical\/Health Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692238232"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Known health, medical, or psychiatric conditions","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692110572"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Current medications","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692123766"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Effects and side-effect of medication","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692132688"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Known traumatic events","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692140643"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Medical treatments, therapies, or services (outside of school)","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692150614"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570692169923"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Intervention History","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692361306"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Describe a brief history of the problem behavior and any interventions.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692375525"},{"index":3,"element":"textarea","attributes":{"name":"description_3","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"If applicable, how would you describe the effectiveness of past intervention efforts?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692388449"},{"index":3,"element":"textarea","attributes":{"name":"description_4","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What rewards are currently provided to the student in school? For what and how often?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692388545"},{"index":3,"element":"textarea","attributes":{"name":"description_5","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What consequences are currently used in school for problem behaviors?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692407455"},{"index":3,"element":"textarea","attributes":{"name":"description_6","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What is the typical student response to these consequences?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692417021"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Skills Assessment","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692436456"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_10","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What are the student\'s academic strengths?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692454937"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_11","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What are the student\'s academic needs?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692462466"},{"index":3,"element":"textarea","attributes":{"name":"description_8","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What are the student\'s organizational needs?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692474324"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_12","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What are the student\'s preferred learning styles?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692483064"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_13","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"What are the student\'s social strengths?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570692496386"},{"index":3,"element":"textarea","attributes":{"name":"description_9","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What are the student\'s deficits in regard to social skills with adults and peers?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692522715"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Communication Summary","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570692543126"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Does the student have difficulty in expressing any of these basic communication functions?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Gaining adult attention":"Gaining adult attention","Gaining attention of peers":"Gaining attention of peers","Dealing with a difficult task":"Dealing with a difficult task","Expressing frustration or confusion":"Expressing frustration or confusion","Requesting things of others":"Requesting things of others","Rejecting or protesting something":"Rejecting or protesting something","Indicating preferences or making choices":"Indicating preferences or making choices","Requesting assistance":"Requesting assistance"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570692605327"},{"index":3,"element":"textarea","attributes":{"name":"description_10","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Use the summary below to think about and identify possible replacement behaviors for instruction. Number separate issues in each of the the following fields to clearly connect problem behavior to communication function and replacement behavior.  Target Problem Behavior(s)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox_1","value":"Gaining adult attention","operator":"="},{"field":"checkbox_1","value":"Gaining attention of peers","operator":"="},{"field":"checkbox_1","value":"Dealing with a difficult task","operator":"="},{"field":"checkbox_1","value":"Requesting things of others","operator":"="},{"field":"checkbox_1","value":"Rejecting or protesting something","operator":"="},{"field":"checkbox_1","value":"Indicating preferences or making choices","operator":"="},{"field":"checkbox_1","value":"Requesting assistance","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570692813772"},{"index":3,"element":"textarea","attributes":{"name":"description_14","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Related Communication Function(s)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox_1","value":"Gaining adult attention","operator":"="},{"field":"checkbox_1","value":"Gaining attention of peers","operator":"="},{"field":"checkbox_1","value":"Dealing with a difficult task","operator":"="},{"field":"checkbox_1","value":"Requesting things of others","operator":"="},{"field":"checkbox_1","value":"Rejecting or protesting something","operator":"="},{"field":"checkbox_1","value":"Indicating preferences or making choices","operator":"="},{"field":"checkbox_1","value":"Requesting assistance","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570693189319"},{"index":3,"element":"textarea","attributes":{"name":"description_15","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Possible Replacement Behavior(s)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox_1","value":"Gaining adult attention","operator":"="},{"field":"checkbox_1","value":"Gaining attention of peers","operator":"="},{"field":"checkbox_1","value":"Dealing with a difficult task","operator":"="},{"field":"checkbox_1","value":"Requesting things of others","operator":"="},{"field":"checkbox_1","value":"Rejecting or protesting something","operator":"="},{"field":"checkbox_1","value":"Indicating preferences or making choices","operator":"="},{"field":"checkbox_1","value":"Requesting assistance","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570693182568"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570693241639"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Consequence Analysis","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570693246106"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_14","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Thinking about the last few times the behavior occurred, what typically actually happens immediately afterward?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693259824"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_15","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Are demands typically altered after the target behavior?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693270694"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_16","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Does someone usually intervene to help the student after the target behavior?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693281502"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_17","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Does the student gain access to something that he\/she appears to want?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693290589"},{"index":3,"element":"textarea","attributes":{"name":"description_16","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Does the behavior appear pleasurable to the student apart from what else is going on around him\/her?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570693299919"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_18","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Does the behavior appear to give the student control of others or the situation? Explain.","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693309895"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_19","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Does the behavior, or do related behaviors, appear to be compulsive (i.e., repetitive, internally driven)? Explain.","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570693352870"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 92
            'finance_application_form'              => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Finance Application Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to create finance application form.',
                'category'   => "Finance",
                'tag'        => "Finance",
                'json'       => '[{"id":"92","title":"Finance Application Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Finance Application\t","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570699678710"},{"index":2,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date","admin_field_label":"","label_placement":"","date_format":"m\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570699483235"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Sales Person","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570699667479"}]},{"fields":[{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Choose One","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Individual Credit":"Individual Credit","Joint Credit":"Joint Credit"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570699506553"}]}],"editor_options":{"title":"Three Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570699473578"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570699786078"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2>Applicant Name:<\/h2>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570700145081"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570699761165"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570699868756"}]},{"fields":[]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570699864073"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Social Security Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570699945451"},{"index":2,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Birth Date","admin_field_label":"","label_placement":"","date_format":"m\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570699995268"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Home Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700031669"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Cell Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700064870"}]}],"editor_options":{"title":"Three Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570699889337"},{"index":2,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Applicant Email ","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570700341279"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_2","value":"","id":"","class":"","placeholder":"ex: 23"},"settings":{"container_class":"","label":"Number of Dependants","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700371647"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_3","value":"","id":"","class":"","placeholder":"00 years 00 month"},"settings":{"container_class":"","label":"Time at Resident","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700064870"}]}],"editor_options":{"title":"Three Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570700325201"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Present Address","admin_field_label":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Street Address","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Street Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700685712"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"Previous Address ( If less than 2 years at present address )","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Street Address","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Street Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700788152"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Employer Information","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570700865459"},{"index":2,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_4","value":"","id":"","class":"","placeholder":"ex: 23"},"settings":{"container_class":"","label":"How Many Years","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700917049"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_5","value":"","id":"","class":"","placeholder":"$000,00.00"},"settings":{"container_class":"","label":"Gross Annual Income ","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701088541"}]},{"fields":[{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Mark please ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Military":"Military","Spouse":"Spouse","Single":"Single"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570701132423"}]}],"editor_options":{"title":"Three Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570700882691"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_6","value":"","id":"","class":"","placeholder":"ex: 23"},"settings":{"container_class":"","label":"Military Unit Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701211272"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_7","value":"","id":"","class":"","placeholder":"ex: 23"},"settings":{"container_class":"","label":"Military Rank","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701221873"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701192286"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_8","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Work Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701287515"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_9","value":"","id":"","class":"","placeholder":"$000,00.00"},"settings":{"container_class":"","label":"Numeric Field","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701305635"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701278024"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Source of Additional Income","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570701344289"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"<div class=\"form-header-group \">\n<div class=\"header-text httac htvam\">\n<h2 id=\"header_45\" class=\"form-header\" style=\"text-align: center;\" data-component=\"header\">Co-Applicant Information<\/h2>\n<\/div>\n<\/div>\n<p>&nbsp;<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570701398711"},{"index":0,"element":"input_name","attributes":{"name":"names_2","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"ff-edit-name","template":"nameFields"},"uniqElKey":"el_1570859339482"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_1","value":"","id":"","class":"","placeholder":"Email Address"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"ff-edit-email","template":"inputText"},"uniqElKey":"el_1570859345110"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_10","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Cell Phone Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570701470956"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"ff-edit-address","template":"addressFields"},"uniqElKey":"el_1570859349319"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570701489712"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"<p>By clicking the submit button, I agree to terms &amp; conditions<\/p>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570701603420"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>I authorize the XXX to make whatever inquires it deems necessary in connection with this credit application and in the course of review or collection of any credit extended in reliance on this application. I further authorized any person or YYY to complete and finish to the XXX any information that it may have or obtain in response to such inquires and agree that such information along with this application shall remain the XXX\'s property, whether or not credit is extended. All information stated in this application is declared to be a true representation of the facts and made for the purpose of obtaining the credit request. I HAVE REVIEWED THE ABOVE DISCLOSURE.<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570701686850"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 94
            'blood_donation_form'                   => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Blood Donation Form',
                'is_pro'     => false,
                'brief'      => 'To create a blood donation form, you can use this form.',
                'category'   => "Nonprofit",
                'tag'        => ["Nonprofit", "blood donation", "volunteer"],
                'json'       => '[{"id":"94","title":"Blood Donation Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Donate blood save life","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570696019397"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\">[Add your company logo her]<\/p>\n<p style=\"text-align: center;\">[Your company Address]<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570695661845"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Donor\'s Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name"},"settings":{"container_class":"","label":"Donor\'s First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false},"settings":{"container_class":"","label":"Donor\'s Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570695037123"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":"dd\/mm\/yy"},"settings":{"container_class":"","label":"Date of birth","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570695185518"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Donor\'s Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570695245123"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Donor\'s Phone","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570695257011"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Permanent Address ","admin_field_label":"","help_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Current Address ","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570695312563"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Blood Group","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"O+":"O+","O-":"O-","A+":"A+","A-":"A-","B+":"B+","B-":"B-","AB+":"AB+","AB-":"AB-"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570695412686"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Have you done a blood donation before?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570695595515"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Do you have any known allergy?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570703537287"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"green","container_class":"","help_message":"","background_color":"#67C23A","button_size":"sm","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 95
            'room_booking_form'                     => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Room Booking Form',
                'is_pro'     => true,
                'brief'      => 'You can use this form to book a room in a hotel.',
                'category'   => "Finance",
                'tag'        => ["Hotel", "finance", "room booking"],
                'json'       => '[{"id":"95","title":"Room Booking Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Book a Room","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570696919480"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>[Add Your Hotel Logo]<\/strong><\/p>\n<p style=\"text-align: center;\"><strong>[Add Your Hotel Name]<\/strong><\/p>\n<p style=\"text-align: center;\"><strong>[Add Your Hotel Address]<\/strong><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570696828484"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570696950842"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570696964480"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Room Type","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Standard room ( 1 to 2 people )":"Standard room ( 1 to 2 people )","Family room ( 1 to 4 people )":"Family room ( 1 to 4 people )","Private room ( 1 to 3 people )":"Private room ( 1 to 3 people )","Only female room":"Only female room"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570696990504"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":"dd\/mm\/yy"},"settings":{"container_class":"","label":"Arrival Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570697190440"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":"dd\/mm\/yy"},"settings":{"container_class":"","label":"Departure Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570697195279"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"No. of people","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570697423440"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Special Requests","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570697445463"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{"backgroundColor":"rgba(227, 166, 14, 1)","color":"#F5E8E8"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 96
            'marriage_gift_registration'            => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Marriage Gift Registration',
                'is_pro'     => true,
                'brief'      => 'Use this form to register the gifts on your marriage.',
                'category'   => "Social",
                'tag'        => ["Gift", "social", "registration"],
                'json'       => '[{"id":"96","title":"Marriage Gift Registration,"form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 style=\"text-align: center;\" data-component=\"header\">[Add a Couple Image Here]<\/h2>\n<h2 id=\"header_1\" class=\"form-header\" style=\"text-align: center;\" data-component=\"header\"><span style=\"font-size: 16px;\">Our Wedding Gifts Registry<\/span><\/h2>\n<div id=\"subHeader_1\" class=\"form-subHeader\" style=\"text-align: center;\">Please select What you plan to give - Thank You<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570698614512"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Gift quantity","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570699327908"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Gift Name","label_placement":"top","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570698708437"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name ","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Your First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Your Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570698917813"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570699574779"}]},{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570699579971"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570699570499"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"","admin_field_label":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address ","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570698745981"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"center","button_style":"red","container_class":"","help_message":"","background_color":"#F56C6C","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 97
            'accident_report_form'                  => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Accident Report Form',
                'is_pro'     => false,
                'brief'      => 'Use this form to report an accident.',
                'category'   => "Government",
                'tag'        => ["Government", "report"],
                'json'       => '[{"id":"97","title":"Accident Report Form","form":{"fields":[{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"I am reporting a :","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Loss of time\/injury":"Loss of time\/injury","Work vehicle accident":"Work vehicle accident","Work accident":"Work accident","First aid incident":"First aid incident","Observation":"Observation"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570698626401"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Person Reporting Incident","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570698896825"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Person Reporting Incident (Name)","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570698682321"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Person Involved in Incident","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570698915027"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Person Reporting Incident (Name)","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570698838638"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Incident Date and Time","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y h:i K","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570698969680"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Location of Incident","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570699010617"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Please describe the event in detail.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570699031846"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Was damage done to the property?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570699051601"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"How many hours were lost because of this incident?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570699066851"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What first aid measures were needed?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570699080287"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Could this incident been avioded?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570699096303"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"I certify that the information I have provided is truthful to the best of my knowledge.\n","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570699117158"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 98
            'bug_report_form'                       => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Bug Report From',
                'is_pro'     => true,
                'brief'      => 'You can use this form to report a bug.',
                'category'   => "IT",
                'tag'        => ["IT", "bug", "report", "tech"],
                'json'       => '[{"id":"98","title":"Bug Report From","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 class=\"fsSectionHeading\" style=\"text-align: center;\">Bug Report<\/h2>\n<div class=\"fsSectionText\">\n<p style=\"text-align: center;\">Please be as detailed as possible to aid us in the troubleshooting process.<\/p>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570699342053"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570699386484"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570699410878"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date and time you first noticed this bug","admin_field_label":"","label_placement":"","date_format":"m\/d\/Y h:i K","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570699445478"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Impact","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Low":"Low","Medium":"Medium","High":"High","Emergency":"Emergency"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570699483067"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Detailed explanation of bug","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570699556732"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Upload a screen capture (optional)","admin_field_label":"","label_placement":"right","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":["jpg|jpeg|gif|png|bmp","doc|ppt|pps|xls|mdb|docx|xlsx|pptx|odt|odp|ods|odg|odc|odb|odf|rtf|txt","pdf","avi|divx|flv|mov|ogv|mkv|mp4|m4v|divx|mpg|mpeg|mpe|video\/quicktime|qt"],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570699582345"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"right","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"sm","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 100
            'check_request_form'                    => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Check Request Form',
                'is_pro'     => false,
                'brief'      => 'This form can be used to do a check request from a bank.',
                'category'   => "Finance",
                'tag'        => ["Finance", "bank", "request"],
                'json'       => '[{"id":"100","title":"Check Request Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 class=\"fsSectionHeading\" style=\"text-align: center;\">Check Request<\/h2>\n<div class=\"fsSectionText\">\n<p style=\"text-align: center;\">If you are in need of funds, please fill out the following check request. We will reach out to you once the request has been approved. If this is an emergency, please contact the financial department directly.<\/p>\n<\/div>\n<div id=\"gtx-trans\" style=\"position: absolute; left: -17px; top: -4.09375px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570699935694"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h3>Requested By:<\/h3>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570699970041"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570700028158"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570700033589"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570700039785"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date Requested","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570700049670"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date Needed","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570700064579"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Purpose of Funds","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570700091770"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Amount Requested ($)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]},"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700125004"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h3>Make Payable To\n:<\/h3>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570700204801"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570700247628"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Payable to Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700261819"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"I have read and agree to the <a href=\"#\">Terms and Conditions<\/a> and <a href=\"#\">Privacy Policy<\/a>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570700286895"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 120
            'quote_request_form'                    => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Quote Request Form',
                'is_pro'     => true,
                'brief'      => 'To create an online quote request form, use this.',
                'category'   => "Finance",
                'tag'        => ["IT", "finance", "quote", "work"],
                'json'       => '[{"id":"120","title":"Quote request (final)","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"REQUEST FOR QUOTE","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570709716273"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date","admin_field_label":"","label_placement":"","date_format":"m\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570709737257"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570709776789"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"CONTACT INFORMATION","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570709794267"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570709814795"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570709821047"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860545019"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"PRODUCTS","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570709834544"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>ITEM 1<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570710083917"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Product Name:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570710076041"}]},{"fields":[{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Quantity","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570709979534"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570709935743"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>ITEM 2<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570710203341"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Product Name:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570710076041"}]},{"fields":[{"index":7,"element":"select","attributes":{"name":"dropdown_4","value":"","id":"","class":""},"settings":{"label":"Quantity","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570709979534"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570710195267"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>ITEM 3<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570710208172"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Product Name:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570710076041"}]},{"fields":[{"index":7,"element":"select","attributes":{"name":"dropdown_3","value":"","id":"","class":""},"settings":{"label":"Quantity","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570709979534"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570710194731"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>NOTES<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570710260879"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Additional comments or questions:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570710276122"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'pricing_survey'                 => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Pricing Survey Form',
                'is_pro'     => true,
                'brief'      => 'To create a pricing survey, you can use this form.',
                'category'   => "Marketing",
                'tag'        => ["Marketing", "pricing", "survey"],
                'json'       => '[{"id":"118","title":"Pricing Survey Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>[Your Company Logo]<\/strong><\/p>\n<p style=\"text-align: center;\"><strong>[Your Company Address]<\/strong><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570708684791"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Are you currently a customer?*","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708444583"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860747771"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Which plan are you subscribed to?*","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Plan A":"Plan A","Plan B":"Plan B","Plan C":"Plan C"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708466467"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860754140"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"How long have you been a customer?*","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Less than a month":"Less than a month","1-6 months":"1-6 months","6 months to 1 year":"6 months to 1 year","1-3 years":"1-3 years","More than 3 years":"More than 3 years"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708500468"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860761946"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What do you like about our service?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570708574758"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860811959"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What do you dislike about our service?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570708595852"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860820415"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_3","value":""},"settings":{"container_class":"","label":"Would you recommend our product?*","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708611116"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570860827580"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Do you have any additional comments or suggestions?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570708992854"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 117
            'business_loan_application_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Loan Application Form',
                'is_pro'     => true,
                'brief'      => 'You can use this from to create a loan application form.',
                'category'   => "Finance",
                'tag'        => ["Finance", "business", "loan", "bank", "office", "HR"],
                'json'       => '[{"id":"117","title":"Loan Application Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Business Loan Application","description":"<p>Personal Information<\/p>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570706626857"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570707309715"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"E-mail of Applicant","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570707365695"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone number of Applicant","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570707393205"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Mobile Phone number of Appliicant","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570707411096"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Fax Number of Applicant","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570707426730"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address of Applicant ","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570707441137"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of Birth of Applicant ","admin_field_label":"","label_placement":"","date_format":"m\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570707470645"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Project Details","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570707586605"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Applying as ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Sole Proprietor":"Sole Proprietor","Partnership":"Partnership","Corporation":"Corporation"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570707605038"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"Planned Business Location","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},
                "settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570708766257"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Project Marketing Material","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570708792488"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_1","value":"","id":"","class":""},"settings":{"container_class":"","label":"Project Information","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570708808756"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Does the borrower have an up to date assets and liabilities statement? ","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708836337"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_2","value":"","id":"","class":""},"settings":{"container_class":"","label":"Upload Statement","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_1","value":"yes","operator":"="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570708921032"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Have you previously been financed?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570708855887"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Lender Name ","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_2","value":"yes","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570709060922"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Financing was for","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_2","value":"yes","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570709075948"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Loan Reason","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Construction":"Construction","Asset Purchase":"Asset Purchase","Refinancing":"Refinancing","other":"other"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570709194988"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Project Gross Value","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570709256730"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Loan Amount","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570709268207"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p>The information provided in this application shall not be shared to anyone else and is kept confidential<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570709288118"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"<p>I agree that the information herein are true and correct<\/p>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570709330656"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Application Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},
                "restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 116
            'birthday_invitation_party'      => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Birthday invitation Party Form',
                'is_pro'     => true,
                'brief'      => 'You can use this form to create an invitation form.',
                'category'   => "Social",
                'tag'        => ["Social", "party", "birthday", "nonprofit"],
                'json'       => '[{"id":"116","title":"Birthday invitation Party Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 style=\"color: #3a7ec2; text-align: center;\">Join Birthday Party\u00a0<\/h2>\n<p><img class=\"alignnone\" src=\"https:\/\/www.sweetfrog.com\/assets\/img\/party\/birthdayParty.png\" \/><\/p>\n<p>&nbsp;<\/p>\n<p style=\"text-align: center;\"><span style=\"color: #3e48ab;\"><strong>Date : December<\/strong> 05, 2019\u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0<strong>Time: <\/strong>12:00 am\u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 <strong>Address : 3491 Henry Ford Avenue, Tulsa, OK, Oklahoma, 74120<\/strong><\/span><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570707016847"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570707130166"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"with_extended_validation","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570707183830"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570707134702"},{"index":10,"element":"select","attributes":{"name":"skills","value":[],"id":"","class":"","multiple":true},"settings":{"help_message":"","container_class":"","label":"Food type","admin_field_label":"","label_placement":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Vegan":"Vegan","Non Vegan":"Non Vegan"},"editor_options":{"title":"Multiple Choice","icon_class":"icon-list-ul","element":"select","template":"select"},"uniqElKey":"el_1570707343485"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"How many people you will come with?","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"One":"One","Two":"Two","Three":"Three","Four":"Four","Five":"Five"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570707535809"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'vehicle_inspection_form'              => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Vehicle Inspection Form',
                'is_pro'     => true,
                'brief'      => 'For inspecting vehicle yearly, use this form.',
                'category'   => "Government",
                'tag'        => ["Vehicles", "inspection", "registration"],
                'json'       => '[{"id":"115","title":"Vehicle Inspection Form","form":{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Inspection Date & Time","admin_field_label":"","label_placement":"","date_format":"d.m.Y h:i K","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570705688276"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570705709183"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570705736118"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570705752682"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"License\/Registration Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705764235"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705749717"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570705840867"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"VIN Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705764235"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705782672"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Year","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570705870182"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Make","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705886553"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705860189"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Model","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705906035"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Mileage","label_placement":"","admin_field_label":"","help_message":"", "validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705916699"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705902098"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Checkbox Grid","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required","per_row":true}},"conditional_logics":[],"grid_columns":{"Pass":"Pass","Fail":"Fail"},"grid_rows":{"Front Bumper\t":"Front Bumper\t","Back Bumper\t":"Back Bumper\t","Leaks under vehicle\t":"Leaks under vehicle\t","Tire pressure\t":"Tire pressure\t","Windows\t":"Windows\t","Doors\t":"Doors\t","Front\/Back lights\t":"Front\/Back lights\t","Side mirrors\t":"Side mirrors\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570705937391"}]},{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_1","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Checkbox Grid","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required","per_row":true}},"conditional_logics":[],"grid_columns":{"Pass\t":"Pass\t","Fail":"Fail"},"grid_rows":{"Clean interior\t":"Clean interior\t","Floor free of hazards\t":"Floor free of hazards\t","Seat belts condition\t":"Seat belts condition\t","Mirrors\t":"Mirrors\t","Brake functionality\t":"Brake functionality\t","Heat":"Heat","A\/C\t":"A\/C\t","Warning lights\t":"Warning lights\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570706015907"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705930111"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_2","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Under The Hood","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":true}},"conditional_logics":[],"grid_columns":{"Pass\t":"Pass\t","Fail":"Fail"},"grid_rows":{"Oil level\t":"Oil level\t","Wiper fluid level\t":"Wiper fluid level\t","Belts":"Belts","Hoses":"Hoses","Battery\t":"Battery\t","Brake fluid\t":"Brake fluid\t","Power steering fluid\t":"Power steering fluid\t","Coolant level\t":"Coolant level\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570706098452"}]},{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_3","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Electrical","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":true}},"conditional_logics":[],"grid_columns":{"Pass":"Pass","Fail":"Fail"},"grid_rows":{"Left turn signal\t":"Left turn signal\t","Right turn signal\t":"Right turn signal\t","High beams\t":"High beams\t","Low beams":"Low beams","Emergency flashers\t":"Emergency flashers\t","Horn":"Horn","Windshield wipers\t":"Windshield wipers\t","Brake lights\t":"Brake lights\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570706159529"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570706091279"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_4","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Safety Equipment","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Pass":"Pass","Fail":"Fail"},"grid_rows":{"Reflective triangles or flares\t":"Reflective triangles or flares\t","First aid kit\t":"First aid kit\t","Bio-hazard kit\t":"Bio-hazard kit\t","Seatbelt cutter\t":"Seatbelt cutter\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570706254179"}]},{"fields":[{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_5","data-type":"tabular-element"},"settings":{"tabular_field_type":"checkbox","container_class":"","label":"Accessiblity Equipment (if applicable)","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Pass\t":"Pass\t","Fail":"Fail"},"grid_rows":{"Cycle lift\t":"Cycle lift\t","Proper number of seat belts\t":"Proper number of seat belts\t","Emergency handle\t":"Emergency handle\t","Hydraulic fluid\t":"Hydraulic fluid\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570706304743"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570706249764"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Notes","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570706366098"},{"index":15,"element":"input_image","attributes":{"type":"file","name":"image-upload","value":"","id":"","class":"","accept":"image\/*"},"settings":{"container_class":"","label":"Upload Relevant Images","admin_field_label":"","label_placement":"left","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_image_types":{"value":[],"message":"Allowed image size does not match"}},"conditional_logics":[]},"editor_options":{"title":"Image Upload","icon_class":"icon-picture-o","template":"inputFile"},"uniqElKey":"el_1570706381051"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Signature","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570706401235"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p><span id=\"label64788387\" class=\"fsLabel\">Inspector Name:<\/span><\/p>\n<div class=\"fsSubFieldGroup\">\n<div class=\"fsSubField fsNameFirst\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570706419899"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570706433668"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 114
            'workshop_registration_form'           => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Workshop Registration Form',
                'is_pro'     => true,
                'brief'      => 'For doing a workshop registration, you can use this from',
                'category'   => "Marketing",
                'tag'        => ["Marketing", "workshop", "registration"],
                'json'       => '[{"id":"114","title":"Workshop Registration Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 id=\"header_15\" class=\"form-header\" style=\"text-align: center;\" data-component=\"header\"><span style=\"color: #3838b0;\">Workshop Registration<\/span><\/h2>\n<p style=\"text-align: center;\">[Add a cool image here]<\/p>\n<div style=\"text-align: center;\"><span style=\"color: #3e48ab;\"><strong>Date : December<\/strong> 05, 2020\u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0<strong>Time: <\/strong>10:00 am\u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 \u00a0 <strong>Address : 3491 Henry Ford Avenue, Tulsa, OK, Oklahoma, 74120 <\/strong><\/span><\/div>\n<div style=\"text-align: center;\">\u00a0<\/div>\n<div id=\"subHeader_15\" class=\"form-subHeader\" style=\"text-align: center;\">\u00a0<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570704891675"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705071258"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570705106754"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570705150569"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705254380"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Permanent Address ","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Current Address","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570705202842"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"How did you hear about the workshop?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Website":"Website","Friend\/Colleague":"Friend\/Colleague","Online Search":"Online Search"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570705299765"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Complete Registration","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 113
            'social_service_home_visit_form'       => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Social Service Home Visit Form',
                'is_pro'     => true,
                'brief'      => 'Use this form to create a social service form.',
                'category'   => "Government",
                'tag'        => ["Government", "social", "service"],
                'json'       => '[{"id":"113","title":"Social Service Home Visit Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Social Worker Name:","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"First Name"},"settings":{"container_class":"","label":"Social Worker Name:","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"Last Name","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570704937500"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p><span id=\"label73658160\" class=\"fsLabel\">Case Name:<\/span><\/p>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 123px; top: -10px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570705081684"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570705039315"}]},{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p><span id=\"label73658166\" class=\"fsLabel\">Case Worker:<\/span><\/p>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 133px; top: -10px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570705114777"},{"index":0,"element":"input_name","attributes":{"name":"names_2","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570705058052"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705034852"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Case Type:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570705185241"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date & Time of Visit:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y h:i K","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570705200289"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Check all that apply:","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},
                "options":{"The home appears to be clean, safe, sanitary and in good repair":"The home appears to be clean, safe, sanitary and in good repair","Waste is stored, located and disposed of in a manner that will not permit the transmission of communicable disease or odors, create a nuisance, or provide a breeding place or food source for insects or rodents":"Waste is stored, located and disposed of in a manner that will not permit the transmission of communicable disease or odors, create a nuisance, or provide a breeding place or food source for insects or rodents","At least one toilet, bath or shower with hot and cold running water":"At least one toilet, bath or shower with hot and cold running water","An operable heating system":"An operable heating system","Suitable sleeping areas \u2013 no halls, stairways, unfinished attic, garage, bathroom, eating area, closet, shed, or detached buildings":"Suitable sleeping areas \u2013 no halls, stairways, unfinished attic, garage, bathroom, eating area, closet, shed, or detached buildings","Children of the opposite sex who are 5 or older do not share the same bedroom":"Children of the opposite sex who are 5 or older do not share the same bedroom","Each child is provided with a clean, comfortable mattress, clean linens, blankets and a pillow":"Each child is provided with a clean, comfortable mattress, clean linens, blankets and a pillow","Medication and toxic substances are locked up so that children in the home cannot access":"Medication and toxic substances are locked up so that children in the home cannot access","Operable telephone":"Operable telephone","Emergency telephone numbers \u2013 including fire, police, poison control and ambulance must be conspicuously posted adjacent to all telephones":"Emergency telephone numbers \u2013 including fire, police, poison control and ambulance must be conspicuously posted adjacent to all telephones","Fireplaces, fireplace inserts, wood and coal burning stoves and free standing space heaters, if allowed by local ordinance, shall be installed equipped and operated according to manufacturer\u2019s specification and requirements specified by local ordinance":"Fireplaces, fireplace inserts, wood and coal burning stoves and free standing space heaters, if allowed by local ordinance, shall be installed equipped and operated according to manufacturer\u2019s specification and requirements specified by local ordinance","Smoke detector on each level of residence (including basement)":"Smoke detector on each level of residence (including basement)","Fire extinguisher gauge or button ensures adequate pressure. If there is not gauge or button, the extinguisher is tested and tagged by fire company or appropriate source":"Fire extinguisher gauge or button ensures adequate pressure. If there is not gauge or button, the extinguisher is tested and tagged by fire company or appropriate source","Protective caps in all electrical outlets (children under 5)":"Protective caps in all electrical outlets (children under 5)","No exposed electrical wires":"No exposed electrical wires","Guns locked and ammunition stored separately":"Guns locked and ammunition stored separately","Number of persons transported does not exceed vehicle capacity":"Number of persons transported does not exceed vehicle capacity","Seat belts in automobiles are used by occupants":"Seat belts in automobiles are used by occupants","Children who are under eight (8) years of age who are transported in motor vehicles shall be securely fastened in a child passenger restraint system":"Children who are under eight (8) years of age who are transported in motor vehicles shall be securely fastened in a child passenger restraint system","Children shall be limited to floor level not more than 2 stories above ground level":"Children shall be limited to floor level not more than 2 stories above ground level","Exits for building with up to and including 2 stories, a minimum of one exit from each floor kept free from obstructions shall be provided":"Exits for building with up to and including 2 stories, a minimum of one exit from each floor kept free from obstructions shall be provided","First Aid supplies in the home":"First Aid supplies in the home","Fire escape plans are posted":"Fire escape plans are posted","Baby gates are used on staircases if they are under 2 years old":"Baby gates are used on staircases if they are under 2 years old"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570705238775"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Smoke Alarms Operable?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570705442044"}]},{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date Checked","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570705453325"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570705436957"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Items Discussed During Visit:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570705467385"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Notes & Comments:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570705477396"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Today\'s Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570705499551"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"I certify that this home meets the standards for approval as described in this form.\n","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570705539668"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 112
            'it_service_request_form'              => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'IT Service Request Form',
                'is_pro'     => false,
                'brief'      => 'To do an IT service request, use this from.',
                'category'   => "IT",
                'tag'        => ["IT", "HR", "request"],
                'json'       => '[{"id":"112","title":"IT Service Request Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<div id=\"fsRow2372377-2\" class=\"fsRow fsFieldRow fsLastRow\">\n<div id=\"fsCell42630375\" class=\"fsRowBody fsCell fsFieldCell fsFirst fsLast fsLabelVertical fsSpan100\" lang=\"en\">\n<p style=\"text-align: center;\"><strong>Please fill out this form and an IT service team member will be in touch with you shortly.<\/strong><\/p>\n<\/div>\n<\/div>\n<div id=\"fsRow2372377-3\" class=\"fsRow fsFieldRow fsLastRow\">\n<div id=\"fsCell42629201\" class=\"fsRowBody fsCell fsFieldCell fsFirst fsLast fsLabelVertical fsSpan100\" lang=\"en\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570704494009"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570704548968"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570704554553"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570704572083"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Department","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704585053"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"What are you having issues with?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Computer":"Computer","Projector":"Projector","Internet Connection":"Internet Connection","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570704609873"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Other","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"Other","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704683360"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Any details we should know about?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570704715658"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Request","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 111
            'handicap_parking_request_form'        => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Handicap Parking Request Form',
                'is_pro'     => true,
                'brief'      => 'For requesting handicap parking, use this form.',
                'category'   => "Government",
                'tag'        => ["Government", "Parking", "HR", "Handicap", "Request"],
                'json'       => '[{"id":"111","title":"Handicap Parking Request Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570704050129"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Mailing Address","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570704066050"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570704076614"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570704090023"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of Birth","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570704099615"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email Address","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570704118618"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Driver License Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704128608"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Application Type","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Permanent Placard":"Permanent Placard","Temporary Placard":"Temporary Placard","Travel Parking Placard":"Travel Parking Placard","Disabled Person License Plate":"Disabled Person License Plate"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570704143105"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"License Plate Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Disabled Person License Plate","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704207888"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Identification Number (VIN)","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Disabled Person License Plate","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704245053"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Make","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Disabled Person License Plate","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704262456"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},
                "settings":{"container_class":"","label":"Vehicle Year","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Disabled Person License Plate","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704289485"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Please attach document from state licensed medical physician to certify disability.","admin_field_label":"","label_placement":"","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":[]},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570704315097"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"<p>The information I have entered is truthful to the best of my knowledge.<\/p>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570704348194"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"right","button_style":"green","container_class":"","help_message":"","background_color":"#67C23A","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 109
            'sponsor_request_form'                 => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Sponsor Request Form',
                'is_pro'     => true,
                'brief'      => 'You can use this from to create a sponsor request form',
                'category'   => "HR",
                'tag'        => ["Finance", "HR", "Sponsor", "Request", "Application"],
                'json'       => '[{"id":"109","title":"Sponsor Request Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 id=\"header_21\" class=\"form-header\" style=\"text-align: center;\"><span style=\"color: #14b5ba;\"><b>Sponsorship <\/b>Request<\/span><\/h2>\n<div id=\"subHeader_21\" class=\"form-subHeader\" style=\"text-align: center;\"><span style=\"color: #14b5ba;\">Lets get started.\u00a0<\/span><\/div>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 284px; top: 50.8125px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570703760412"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Start","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570703348166"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":"John Doe"},"settings":{"container_class":"","label":"What\'s your Name?","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570703829445"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Email Address)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570703363110"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"me@domain.com"},"settings":{"container_class":"","label":"Can you share your email address?","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570703914644"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Phone Number)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570703364125"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Can I have your phone number please?","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570703990707"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Your Address)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570703976588"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"We need your address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address ","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570704012788"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Company)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570703977755"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":"My company name is XXXX"},"settings":{"container_class":"","label":"May I know where do you work?","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704073499"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Type of Sponsorship you want)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570704136150"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Which position do you want to sponsor?","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"Choose Position","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Platinum":"Platinum","Diamond":"Diamond","Gold":"Gold","Silver":"Silver","Bronze":"Bronze"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570704171019"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next (Special Request)","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1570704137965"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Special Request","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570704146115"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit ","img_url":""},"normal_styles":{"backgroundColor":"rgba(11, 148, 163, 1)","color":"#F2EFEF"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 107
            'annual_vehicles_inspection_form'      => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Annual Vehicles Inspection Form',
                'is_pro'     => true,
                'brief'      => 'To create a vehicle inspection from, use this.',
                'category'   => "Government",
                'tag'        => ["Personal", "Government", "social"],
                'json'       => '[{"id":"107","title":"Annual Vehicles Inspection Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: center;\"><strong>Annual Vehicles Inspection Form\u00a0\u00a0<\/strong><\/p>\n<div id=\"gtx-trans\" style=\"position: absolute; left: 302px; top: -9px;\">\n<div class=\"gtx-trans-icon\">\u00a0<\/div>\n<\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570705042179"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Today\'s Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570702169828"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Report Number:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702189377"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Fleet Unit Number:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702214417"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Motor Carrier Operator:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702228346"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570702241922"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Vehicle Type:","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Tractor":"Tractor","Trailer":"Trailer","Truck":"Truck","Other":"Other"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570702260758"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"others","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"checkbox","value":"Other","operator":"="}]}},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570702299067"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_3","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Vehicle Identification Number:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702359683"}]},{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"License Plate Number:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702362115"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570702345905"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Inspector\'s  Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Inspector\'s First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Inspector\'s Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570702383422"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox_1","value":[]},"settings":{"container_class":"","label":"Inspector Meets Requirements of Section 396.19.","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes":"Yes","No":"No"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1570702434514"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Vehicle Inspected Components","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702463925"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Brake System","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection\t":"Passed Inspection\t","Needs Repair\t":"Needs Repair\t","N\/A":"N\/A"},"grid_rows":{"Service Brakes":"Service Brakes","Parking Brake":"Parking Brake","Brake Drums\/Rotors":"Brake Drums\/Rotors","Brake Hose":"Brake Hose","Tubing":"Tubing","Low Pressure Warning Device":"Low Pressure Warning Device","Air Compressor":"Air Compressor","Tractor Protection Valve":"Tractor Protection Valve","Electric Brakes":"Electric Brakes","Hydraulic Brakes":"Hydraulic Brakes","Vacuum Systems":"Vacuum Systems"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570702478197"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Brake Repair:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702647731"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Brake Repair:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702708506"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702695685"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Brake Repair:","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702707125"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Brake Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570702711967"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Coupling Devices","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702731852"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_1","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Fifth Wheels":"Fifth Wheels","Saddle-Mounts":"Saddle-Mounts","Drawbar\/Towbar Tongue":"Drawbar\/Towbar Tongue","Drawbar\/Towbar Eye":"Drawbar\/Towbar Eye","Pintle Hooks":"Pintle Hooks"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570702745869"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702845420"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570702861641"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702895559"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_5","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702903793"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_3","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570702907112"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Steering Mechanism","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702925893"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_2","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Checkbox Grid","admin_field_label":"Check All That Apply:","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection\t":"Passed Inspection\t","Needs Repair\t":"Needs Repair\t","N\/A":"N\/A"},"grid_rows":{"Steering Column\t":"Steering Column\t","Steering System\t":"Steering System\t","Steering Gear Box\t":"Steering Gear Box\t","Pitman Arm\t":"Pitman Arm\t","Power Steering\t":"Power Steering\t","Steering Wheel Free Play\t":"Steering Wheel Free Play\t","Front Axle Beam + Related Components\t":"Front Axle Beam + Related Components\t","Tie Rods and Drag Links\t":"Tie Rods and Drag Links\t","Ball and Socket Joints\t":"Ball and Socket Joints\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570702960134"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_6","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703058776"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_4","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703076064"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703087795"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Suspension","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703117781"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_3","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"U-bolts, Springs, Etc. Cracked or Broken":"U-bolts, Springs, Etc. Cracked or Broken","Torque, Radius or Tracking Components":"Torque, Radius or Tracking Components","Spring Assembly":"Spring Assembly"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703137123"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_8","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703215555"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_6","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703225083"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Exhaust System","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703236236"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_4","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Leaks found at a point forward of or directly below the driver\/sleeper compartment":"Leaks found at a point forward of or directly below the driver\/sleeper compartment","Found burning, charring, or damage to the electrical wiring":"Found burning, charring, or damage to the electrical wiring"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703251764"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_9","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703327233"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_7","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703340767"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Fuel System","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703419509"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_5","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Visible Leak":"Visible Leak","Fuel Tank Filler Cap Missing":"Fuel Tank Filler Cap Missing"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703543075"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_10","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703565823"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_8","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703569235"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Frame","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703591382"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_6","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Adjustable Axle Assemblies\t":"Adjustable Axle Assemblies\t","Tire and Wheel Clearance\t":"Tire and Wheel Clearance\t","Frame Members\t":"Frame Members\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703603379"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_11","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703668171"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_9","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703634146"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Tires, Wheels and Rims","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703693284"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_7","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Tire Tread\t":"Tire Tread\t","Lock or Side Ring\t":"Lock or Side Ring\t","Wheels and Rims Not Bent\t":"Wheels and Rims Not Bent\t","Fasteners\t":"Fasteners\t","Welds\t":"Welds\t"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703721139"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_12","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703754960"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_10","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703760776"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Windshield and Wipers","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703770500"},{"index":9,"element":"tabular_grid","attributes":{"name":"tabular_grid_8","data-type":"tabular-element"},"settings":{"tabular_field_type":"radio","container_class":"","label":"Check All That Apply:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required","per_row":false}},"conditional_logics":[],"grid_columns":{"Passed Inspection":"Passed Inspection","Needs Repair":"Needs Repair","N\/A":"N\/A"},"grid_rows":{"Cracks or Holes That Impede Vision\t":"Cracks or Holes That Impede Vision\t","Wiper Missing Parts":"Wiper Missing Parts","Wipers Fully Functional":"Wipers Fully Functional"},"selected_grids":[]},"editor_options":{"title":"Checkable Grid","icon_class":"icon-dot-circle-o","template":"checkableGrids"},"uniqElKey":"el_1570703787421"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_13","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570703816781"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_11","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Repair Date:","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570703821324"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Other Misc:","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570703838302"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Other Observations\/Issues to Address:","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570703880998"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"I have read and agree to the <a href=\"#\">Terms and Conditions<\/a> and <a href=\"#\">Privacy Policy<\/a>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570703902999"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 106
            'finance_department_analysis_form'     => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Finance Department Analysis Form',
                'is_pro'     => false,
                'brief'      => 'For finance analysis, you can use this form.',
                'category'   => "Finance",
                'tag'        => ["Finance", "department", "HR"],
                'json'       => '[{"id":"106","title":"Finance Department Analysis Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Finance Department Analysis Registration Form","description":"<div class=\"form-header-group \">\n<div class=\"header-text httal htvam\">\n<div id=\"subHeader_10\" class=\"form-subHeader\">Please provide all required information to have one of our finance specialist contact you.<\/div>\n<\/div>\n<\/div>","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570702201715"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Dealership Name ","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570702235117"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570702266805"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Best Contact Number","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702291869"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570702314334"},{"index":11,"element":"input_url","attributes":{"type":"url","name":"url","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Dealership Website","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"url":{"value":true,"message":"This field must contain a valid url"}},"conditional_logics":[]},"editor_options":{"title":"Website URL","icon_class":"icon-link","template":"inputText"},"uniqElKey":"el_1570702325118"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Message","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570702369443"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 104
            'swimming_competition_enrollment_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Swimming Competition Enrollment Form',
                'is_pro'     => true,
                'brief'      => 'For arranging a swimming competition, you can use this form.',
                'category'   => "Healthcare",
                'tag'        => ["Healthcare", "health", "Swimming", "fun activities"],
                'json'       => '[{"id":"104","title":"Swimming Competition Enrollment Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 id=\"header_1\" class=\"form-header\" style=\"text-align: center;\" data-component=\"header\"><span style=\"color: #14a7ba;\">Swimming Competition enrollment<\/span><\/h2>\n<p style=\"text-align: center;\"><span style=\"color: #14a7ba;\">Please fill this form out to enter into the competition -<\/span><\/p>\n<p style=\"text-align: center;\">[Add an awesome image here]<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570701198346"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570701611969"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Height","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570702029623"}]},{"fields":[{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Select age group ","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"5-12 Years":"5-12 Years","13-21 Years":"13-21 Years","Above 21":"Above 21"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1570702048722"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570702017696"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Parantes full Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Father Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Mother Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570704618609"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570701901999"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570701906671"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701891855"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"ff-edit-step","template":"formStep"},"uniqElKey":"el_1570861649059"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570704788044"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Register","img_url":""},"normal_styles":{"backgroundColor":"rgba(29, 184, 190, 1)","color":"#F8EFEF"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 103
            'confidential_morbidity_form'          => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Confidential Morbidity Form',
                'is_pro'     => true,
                'brief'      => 'You can use this form to create a confidential morbidity form.',
                'category'   => "Government",
                'tag'        => ["Government", "request", "application"],
                'json'       => '[{"id":"103","title":"Confidential Morbidity Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Provider Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570700891109"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Physician\'s Name (First Name)","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570700919333"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Physician\'s  Phone Number","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570700962710"}]},{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone_1","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Facility Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570700969356"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570700960274"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Facility Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700990101"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Patient Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570701000610"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Patient Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Patient Name(First Name)","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570701019944"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of Birth","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701057536"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address2","data-type":"address-element"},"settings":{"label":"Patient Address","admin_field_label":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},
                "settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570701078768"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Patient Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570701100489"}]},{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone_2","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Patient Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570701109151"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701096584"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Race","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"White":"White","Black":"Black","Asian":"Asian","Native American":"Native American","Pacific Islander":"Pacific Islander","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570701147479"}]},{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Ethnicity","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Hispanic":"Hispanic","Non-Hispanic":"Non-Hispanic"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570701210101"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Other (Race)","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"Other","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570704399993"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701138843"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Gender","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Male":"Male","Female":"Female","Transgender, Male-Female":"Transgender, Male-Female","Transgender, Female-Male":"Transgender, Female-Male"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570701289836"}]},{"fields":[{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Social Security Number","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570701320803"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701274582"},{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p><span id=\"label72178383\" class=\"fsLabel\">Parent\/Guardian Name:<\/span><\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570701987911"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names_2","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570701434879"}]},{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone_3","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Parent\/Guardian Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570701508786"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701423376"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Disease","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1570701667839"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Disease or Condition Name","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text",
                    "icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1570701686560"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Admission Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701742849"}]},{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Onset Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701731895"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701708987"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_3","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Diagnosis Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701753303"}]},{"fields":[{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_4","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Discharge Date","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570701765837"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701710356"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Symptoms","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570701783552"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_3","value":""},"settings":{"container_class":"","label":"Was laboratory testing ordered?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570701837595"}]},{"fields":[{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"If yes, attach the results:","admin_field_label":"","label_placement":"top","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_3","value":"yes","operator":"="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570701843955"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701834667"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_4","value":""},"settings":{"container_class":"","label":"What the patient treated?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570701837595"}]},{"fields":[{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload_1","value":"","id":"","class":""},"settings":{"container_class":"","label":"If yes, provide treatment details:","admin_field_label":"","label_placement":"top","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":[],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_4","value":"yes","operator":"="}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1570701843955"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570701869808"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Description of other illnesses\/treatments","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570701933662"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"center","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"sm","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 102
            'complaint_form'                       => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Complaint form',
                'is_pro'     => false,
                'brief'      => 'You can use this form to create a complain from.',
                'category'   => "Government",
                'tag'        => ["Government", "complaint"],
                'json'       => '[{"id":"102","title":"Complaint form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h4 style=\"text-align: center;\">Please fill out the following form with your complaint. We will review your request and follow up with you as soon as possible.<\/h4>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570700478440"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570700501773"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570700506162"},{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570700517273"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1570700525086"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of incident","admin_field_label":"","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1570700544335"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Please describe the incident you would like to report.","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570700562387"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"How would you like to see this incident resolved?","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570700576572"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"<p>All the data I submitted is truthfull, and I am responsible for that.<\/p>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1570700591050"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            //form number : 101
            'charity_dinner_party_form'            => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Charity Dinner Party Form',
                'is_pro'     => false,
                'brief'      => 'This form can be used to create a charity dinner party form.',
                'category'   => "Nonprofit",
                'tag'        => ["Nonprofit", "party", "charity"],
                'json'       => '[{"id":"101","title":"Charity Dinner Party Form","form":{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<h2 id=\"header_1\" class=\"form-header\" style=\"text-align: center;\" data-component=\"header\"><span style=\"color: #115e99;\">Charity Dinner<\/span><\/h2>\n<div id=\"subHeader_1\" class=\"form-subHeader\" style=\"text-align: center;\"><span style=\"color: #115e99;\">Charity dinner for refugee children<\/span><\/div>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1570700259437"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1570700341016"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":30,"element":"phone","attributes":{"name":"phone","class":"","value":"","type":"tel","placeholder":""},"settings":{"container_class":"","placeholder":"","int_tel_number":"no","label":"Phone","label_placement":"top","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"valid_phone_number":{"value":false,"message":"Phone number is not valid"}},"conditional_logics":[]},"editor_options":{"title":"Phone Field","icon_class":"el-icon-phone-outline","template":"inputText"},"uniqElKey":"el_1570700400841"}]},{"fields":[{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1570700405105"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1570700396089"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Will you attend ?","admin_field_label":"","label_placement":"left","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1570700436321"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":"1-3"},"settings":{"container_class":"","label":"Number of Guests","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"1","message":"Minimum value is "},"max":{"value":"3","message":"Maximum value is "}},"conditional_logics":[],"calculation_settings":{"status":false,"formula":""}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1570700528257"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Special Request","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1570700556473"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"","container_class":"","help_message":"","background_color":"","button_size":"md","color":"","button_ui":{"type":"default","text":"Submit Form","img_url":""},"normal_styles":{"backgroundColor":"rgba(52, 118, 173, 1)","color":"#F7F0F0"},"hover_styles":{},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Lets hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"}},"notifications":{"name":"Admin Notification Email","sendTo":{"type":"email","email":"{wp.admin_email}","field":"email","routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"[{inputs.names}] New Form Submission","message":"<p>{all_data}<\/p>\n<p>This form submitted at: {embed_post.permalink}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'event_registration_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Event Registration Form',
                'brief'      => 'Using this registration form you can enable your event to achieve it\'s goal.',
                'category'   => "Social",
                'tag'        => ["Social", "party", "event", "registration"],
                'json'       => '[{"id":"1","title":"Event Registration Form","form":{"fields":[{"index":2,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"First Name field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1516797727681"},{"index":7,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":"you@domain.com"},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Email field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1516797731343"},{"index":14,"element":"input_number","attributes":{"type":"number","name":"phone","value":"","id":"","class":"","placeholder":"Your phone number"},"settings":{"container_class":"","label":"Phone","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"Phone field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1516798280530"},{"index":1,"element":"input_text","attributes":{"type":"text","name":"company","value":"","class":"","placeholder":"Type your company name"},"settings":{"container_class":"","label":"Company","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":false,"message":"Company field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Input","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1516797770161"},{"index":8,"element":"input_url","attributes":{"type":"url","name":"url","value":"","id":"","class":"","placeholder":"http:\/\/www.google.com"},"settings":{"container_class":"","label":"Website","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"Website field is required"},"url":{"value":true,"message":"This field must contain a valid url"}},"conditional_logics":[]},"editor_options":{"title":"URL","icon_class":"icon-link","template":"inputText"},"uniqElKey":"el_1516798321477"},{"index":2,"element":"textarea","attributes":{"name":"message","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Message (if any)","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Textarea","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1516797774136"}],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline"},"id":"29"},"notifications":{"name":"Event Registration Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Event Registration Form submitted","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'vendor_contact_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Vendor Contact Form',
                'brief'      => 'Easily create a vendor contact form and get logged in user details easily.',
                'category'   => "Finance",
                'tag'        => ["Contact", "form", "get in touch", "registration"],
                'json'       => '[{"id":"2","title":"Vendor Contact Form","form":{"fields":[{"index":0,"element":"input_hidden","attributes":{"type":"hidden","name":"hidden","value":"{user.first_name} {user.last_name}"},"settings":{"admin_field_label":"Seller Name"},"editor_options":{"title":"Hidden Field","icon_class":"icon-eye-slash","template":"inputHidden"},"uniqElKey":"el_1559107765827"},{"index":0,"element":"input_hidden","attributes":{"type":"hidden","name":"hidden_1","value":"{user.user_email}"},"settings":{"admin_field_label":"Seller mail"},"editor_options":{"title":"Hidden Field","icon_class":"icon-eye-slash","template":"inputHidden"},"uniqElKey":"el_1559106971216"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Subject","label_placement":"","admin_field_label":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559107049204"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Message","admin_field_label":"","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559107086831"}],"submitButton":{"uniqElKey":"el_1559106893440","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Vendor Contact Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"{inputs.input_text}","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'patient_intake_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Patient Intake Form',
                'brief'      => 'Using this form you can get the patient information with the medical history.',
                'category'   => "Healthcare",
                'tag'        => ["healthcare", "patient", "hospital", "clinic", "medical"],
                'json'       => '[{"id":"6","title":"Patient Intake Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Patient Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559109481426"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Patient Age","admin_field_label":"Patient Age","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559109564397"},{"index":0,"element":"input_name","attributes":{"name":"names_1","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Prefered Name \/ Nickname","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Prefered Name \/ Nickname","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559109792382"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Patient Gender","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Male":"Male","Female":"Female","Others":"Others"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559109642614"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone no.","admin_field_label":"Phone no.","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559274675098"},{"index":0,"element":"input_name","attributes":{"name":"names_2","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Spouce Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Spouce Name","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559109681450"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"With whome do you live?","label_placement":"","admin_field_label":"With whome do you live?","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274086054"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Marital Status","admin_field_label":"Marital Status","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Married":"Married","Unmarried":"Unmarried","other":"other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559274134558"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Marital status(other)","label_placement":"","admin_field_label":"Marital status(other)","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"other","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274183772"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":"If retired or disabled enter your last occupation"},"settings":{"container_class":"","label":"Occupation","label_placement":"","admin_field_label":"Occupation","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274252192"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"Retired? ","admin_field_label":"Retired? ","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559274467432"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of retirement","admin_field_label":"Date of retirement","label_placement":"","date_format":"m\/d\/y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_1","value":"yes","operator":"="}]}},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559274499317"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Disability ?","admin_field_label":"Disability ?","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559274553377"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Date of disability","admin_field_label":"Date of disability","label_placement":"","date_format":"m\/d\/y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_2","value":"yes","operator":"="}]}},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559274530031"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Who is your primary care doctor: ","label_placement":"","admin_field_label":"Who is your primary care doctor: ","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274621989"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Where is your primary care doctor located ? ","label_placement":"","admin_field_label":"Where is your primary care doctor located ? ","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274635900"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_5","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone Number of primary care doctor:","label_placement":"","admin_field_label":"Phone Number of primary care doctor:","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274697189"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_3","value":""},"settings":{"container_class":"","label":"allergic to any medications","admin_field_label":"allergic to any medications","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559274799405"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_6","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"allergic to any medications","label_placement":"","admin_field_label":"allergic to any medications","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_3","value":"yes","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274743792"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_4","value":""},"settings":{"container_class":"","label":"Do you smoke? ","admin_field_label":"Do you smoke? ","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559274844179"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_7","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"How many years did you smoke?","label_placement":"","admin_field_label":"How many years did you smoke?","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio_4","value":"yes","operator":"="}]}},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274869218"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_8","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"If you quit, when did you stop?","label_placement":"","admin_field_label":"If you quit, when did you stop?","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274922518"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_9","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Do you drink alcohol? ","label_placement":"","admin_field_label":"Do you drink alcohol? ","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559274938140"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Personal opinion","admin_field_label":"Personal opinion","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559275053975"}],"submitButton":{"uniqElKey":"el_1559109464078","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Patient Intake Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Patient Intake Form Notification","message":"<p>{all_data}<\/p>\n<p>&nbsp;<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'volunteer_application_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Volunteer Application Form',
                'brief'      => 'Get volunteer applicants data according to their particular interests with working days.',
                'category'   => "Nonprofit",
                'tag'        => ["volunteer", "nonprofit", "application", "registration"],
                'json'       => '[{"id":"7","title":"Volunteer Application","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559110051637"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559110054313"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Contact No","admin_field_label":"Contact No","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559110059986"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1559110065995"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Working Days","admin_field_label":"Working Days","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{" Sunday":" Sunday","Satarday":"Satarday","Monday":"Monday","Tuesday":"Tuesday","Wednesday":"Wednesday","Thursday":"Thursday","Friday":"Friday"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1559186288251"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Area of Interest\/ skills","admin_field_label":"Area of Interest\/ skills","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559186858825"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Comments (optional)","admin_field_label":"Comments (optional)","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559186958391"}],"submitButton":{"uniqElKey":"el_1559110013898","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Application","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Volunteer Application Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Volunteer Application by {inputs.names}","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'request_for_quote' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Request for Quote',
                'brief'      => 'Get user request for quote using this simple form.',
                'category'   => "IT",
                'tag'        => ["quote", "request", "freelancer", "product"],
                'json'       => '[{"id":"9","title":"Request for Quote","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559111679342"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone no.","admin_field_label":"Phone no.","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559111693607"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559111716176"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Prefered Method of Contact","admin_field_label":"Prefered Method of Contact","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"Phone":"Phone","Email":"Email","other":"other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559111739945"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"other","operator":"="}]}},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1559111849017"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Comments","admin_field_label":"Comments","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559187328513"}],"submitButton":{"uniqElKey":"el_1559111649130","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Request for Quote Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Request for Quote","message":"<p>{all_data}<\/p>\n<p>Form Submitted successfully.<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'conference_proposal' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Conference Proposal',
                'brief'      => 'This sample form is to make a conference proposal efficient and effective.',
                'category'   => "Education",
                'tag'        => ["Conference", "registration", "education", "proposal"],
                'json'       => '[{"id":"10","title":"Conference Proposal","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559112198786"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Job Title","label_placement":"","admin_field_label":"Job Title","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559112216398"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company Name","label_placement":"","admin_field_label":"Company Name","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559112231309"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Biography","admin_field_label":"Biography","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559112255236"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559112265631"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Proposal Title","label_placement":"","admin_field_label":"Proposal Title","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559112290259"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Short Description","admin_field_label":"Short Description","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559112314875"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Abstract","admin_field_label":"Abstract","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559112331026"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Topics","admin_field_label":"Topics","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Topics 1":"Topics 1","Topics 2":"Topics 2","Topics 3":"Topics 3"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1559112363613"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Session Type","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Panel":"Panel","Work shop":"Work shop","Presentation":"Presentation","Other":"Other"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559112402526"},{"index":7,"element":"select","attributes":{"name":"dropdown_1","value":"","id":"","class":""},"settings":{"label":"Audience Level","admin_field_label":"Audience Level","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Novice":"Novice","Intermediate":"Intermediate","Expert":"Expert"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559112480834"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Video URL","label_placement":"","admin_field_label":"Video URL","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559112543915"},{"index":3,"element":"textarea","attributes":{"name":"description_3","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Additional Information","admin_field_label":"Additional Information","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559112578458"}],"submitButton":{"uniqElKey":"el_1559112181623","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"center","button_style":"green","container_class":"","help_message":"","background_color":"#67C23A","button_size":"lg","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form Data","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Conference Proposal Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Conference Proposal","message":"<p>Your data submitted Successfully<\/p>\n<p>{all_data}<\/p>\n<p>&nbsp;<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'report_a_bug' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Report a bug',
                'brief'      => 'You can get user feedback, bug report, and the issue details from user.',
                'category'   => "IT",
                'tag'        => ["IT", "bug", "report", "report a bug"],
                'json'       => '[{"id":"11","title":"Report a bug","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Full Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Full Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559112858212"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Enter Your Email Address ","label_placement":"","help_message":"","admin_field_label":"Email Address","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559112923651"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Title of the Issue","label_placement":"","admin_field_label":"Title of the Issue","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559112936885"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Problem Status","admin_field_label":"Problem Status","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Open":"Open","Hold":"Hold","Fixed":"Fixed","Closed":"Closed","Invalid":"Invalid","Other":"Other"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559112981010"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Summary of the Information","admin_field_label":"Summary Information","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559113034559"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Steps to Reproduce","admin_field_label":"Steps to Reproduce","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559113051369"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Results","admin_field_label":"Results","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559113074493"},{"index":3,"element":"textarea","attributes":{"name":"description_3","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Regression","admin_field_label":"Regression","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559113093300"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Is there a Workaround?","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559113134071"},{"index":3,"element":"textarea","attributes":{"name":"description_4","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Documentation & Notes","admin_field_label":"Documentation & Notes","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559113248045"},{"index":1,"element":"container","attributes":[],"settings":[],"columns":[{"fields":[{"index":3,"element":"custom_html","attributes":[],"settings":{"html_codes":"<p style=\"text-align: right\">Upload Your documents (if need)<\/p>","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Custom HTML","icon_class":"icon-code","template":"customHTML"},"uniqElKey":"el_1559187803664"}]},{"fields":[{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"","admin_field_label":"Optional documents","label_placement":"right","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":2097152,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_file_types":{"value":["jpg|jpeg|gif|png|bmp","mp3|wav|ogg|wma|mka|m4a|ra|mid|midi|mpga","avi|divx|flv|mov|ogv|mkv|mp4|m4v|divx|mpg|mpeg|mpe|video\/quicktime|qt","pdf","doc|ppt|pps|xls|mdb|docx|xlsx|pptx|odt|odp|ods|odg|odc|odb|odf|rtf|txt","zip|gz|gzip|rar|7z","exe","csv"],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1559187757610"}]}],"editor_options":{"title":"Two Column Container","icon_class":"icon-columns"},"uniqElKey":"el_1559187753426"},{"index":7,"element":"select","attributes":{"name":"dropdown_1","value":"","id":"","class":""},"settings":{"label":"Reproducibility","admin_field_label":"Reproducibility","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"I  didn\'t try":"I  didn\'t try","Rarely":"Rarely","Sometimes":"Sometimes","Always":"Always"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559113160537"},{"index":7,"element":"select","attributes":{"name":"dropdown_3","value":"","id":"","class":""},"settings":{"label":"Classification of Bug","admin_field_label":"Classification of Bug","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Security":"Security","Crash \/Hang \/Data loss":"Crash \/Hang \/Data loss","Performance \/Ui-Usability":"Performance \/Ui-Usability","Serious Bug":"Serious Bug","Other Bug":"Other Bug","Feature (New)":"Feature (New)","Enhancement":"Enhancement"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559113361150"},{"index":7,"element":"select","attributes":{"name":"dropdown_2","value":"","id":"","class":""},"settings":{"label":"How severe it is?","admin_field_label":"How severe it is?","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Trivial":"Trivial","Normal":"Normal","Major":"Major","Critical":"Critical"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559113271926"}],"submitButton":{"uniqElKey":"el_1559112849800","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"orange","container_class":"","help_message":"","background_color":"#E6A23C","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Bug Report","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Bug Report Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"New Bug Reported","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'tell_a_friend_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Tell A Friend Form',
                'brief'      => 'Get text from you site users.',
                'category'   => "Social",
                'tag'        => ["social", "friend", "party", "contact"],
                'json'       => '[{"id":"15","title":"Tell A Friend Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559117552587"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"To","label_placement":"","admin_field_label":"To","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559117572857"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Message","admin_field_label":"Message","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559117587626"}],"submitButton":{"uniqElKey":"el_1559117545661","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"center","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Send Message","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Tell A Friend Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Text submitted","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'directory_information_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Directory Information Form',
                'brief'      => 'This form allows you to get the directory information.',
                'category'   => "Government",
                'tag'        => ["government", "directory", "form", "information"],
                'json'       => '[{"id":"16","title":"My Directory Information","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559117767222"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Username","label_placement":"","admin_field_label":"Username","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559117793585"},{"index":11,"element":"input_url","attributes":{"type":"url","name":"url","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Site Address","admin_field_label":"Address","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"url":{"value":true,"message":"This field must contain a valid url"}},"conditional_logics":[]},"editor_options":{"title":"Website URL","icon_class":"icon-link","template":"inputText"},"uniqElKey":"el_1559117830376"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":"no"},"settings":{"container_class":"","label":"Do you want to share your password?","admin_field_label":"Agree to share password","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559188732753"},{"index":12,"element":"input_password","attributes":{"type":"password","name":"password","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Enter your password","admin_field_label":"password","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"yes","operator":"="}]}},"editor_options":{"title":"Password Field","icon_class":"icon-lock","template":"inputText"},"uniqElKey":"el_1559188774833"}],"submitButton":{"uniqElKey":"el_1559117761747","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Informations","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Directory Information Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Directory Information submited","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'request_for_leave' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Request for Leave',
                'category'   => "HR",
                'tag'        => ["office", "leave", "absence", "take a nap"],
                'brief'      => 'Receive leave requests from your employee instantly.',
                'json'       => '[{"id":"18","title":"Request for Leave","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559119229242"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email address(optional)","label_placement":"","help_message":"","admin_field_label":"Email address","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559189778769"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Contact no.","admin_field_label":"Contact no.","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559275288135"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Position","label_placement":"","admin_field_label":"Position","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559119248104"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Manager","label_placement":"","admin_field_label":"Manager","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559119277903"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Leave Start ","admin_field_label":"Leave Start ","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559119287246"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Leave End","admin_field_label":"Leave End","label_placement":"","date_format":"d\/m\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559119907871"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Leave Type ","admin_field_label":"Leave Type ","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Vacation":"Vacation","Sick":"Sick","Quitting":"Quitting","Maternity\/Paternity":"Maternity\/Paternity","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559119926213"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Comments","admin_field_label":"Comments","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559119977368"}],"submitButton":{"uniqElKey":"el_1559119222045","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Apply For Leave","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Request for Leave Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"New Request for Leave","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'admission_form' => array(
                'screenshot' => '',
                'createable' => true,
                'is_pro'     => true,
                'title'      => 'Admissions Form',
                'brief'      => 'Receive new admission students data along with their documents using this sample admission form.',
                'category'   => "Education",
                'tag'        => ["admission", "education", "student", "organisation"],
                'json'       => '[{"id":"5","title":"Admissions Form","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559108914252"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559116838095"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Birth Date","admin_field_label":"","label_placement":"","date_format":"n\/j\/y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559108940886"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Gender","admin_field_label":"","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"options":{"Male":"Male","Female":"Female","Others":"Others"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1559109018303"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Select section","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Section - A":"Section - A","Section - B":"Section - B","Section - C":"Section - C"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559109122333"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Apply for Class","admin_field_label":"Apply for Class","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"O level":"O level","A level":"A level"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559116799977"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Guardian Name","label_placement":"","admin_field_label":"Guardian Name","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559116859101"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Guardian Contact no.","admin_field_label":"Guardian Contact no.","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559116996267"},{"index":15,"element":"input_image","attributes":{"type":"file","name":"image-upload","value":"","id":"","class":"","accept":"image\/*"},"settings":{"container_class":"","label":"Upload Your photo","admin_field_label":"","label_placement":"left","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"max_file_size":{"value":1048576,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":1,"message":"Max file count"},"allowed_image_types":{"value":["jpg|jpeg","png"],"message":"Allowed image size does not match"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Image Upload","icon_class":"icon-picture-o","template":"inputFile"},"uniqElKey":"el_1559117075053"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Comments (optional)","admin_field_label":"Comments(optional)","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559275440101"}],"submitButton":{"uniqElKey":"el_1559108903621","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"right","button_style":"green","container_class":"","help_message":"","background_color":"#67C23A","button_size":"lg","color":"#ffffff","button_ui":{"type":"default","text":"Apply for Admission","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Admissions Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"New Admissions Form submited","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'loan_application_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Loan Application Form',
                'is_pro'     => true,
                'brief'      => 'Get loan application from applicants with their detail information.',
                'category'   => "Finance",
                'tag'        => ["banking", "finance", "loan", "application"],
                'json'       => '[{"id":"8","title":"Loan Application","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Personal Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1559207413587"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Title","admin_field_label":"Title","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Mr":"Mr","Mrs":"Mrs","Ms":"Ms"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559110533621"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559110355217"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Birth Date","admin_field_label":"Birth Date","label_placement":"","date_format":"d.m.Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559110597665"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Marital Status","admin_field_label":"Marital Status","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Single":"Single","Married":"Married","Other":"Other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559110647827"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email","label_placement":"","help_message":"","admin_field_label":"Applicant Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559110700355"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Phone no.","admin_field_label":"Phone no.","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559110739318"},{"index":4,"element":"address","attributes":{"id":"","class":"","name":"address1","data-type":"address-element"},"settings":{"label":"Address","admin_field_label":"","conditional_logics":[]},"fields":{"address_line_1":{"element":"input_text","attributes":{"type":"text","name":"address_line_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 1","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"address_line_2":{"element":"input_text","attributes":{"type":"text","name":"address_line_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Address Line 2","admin_field_label":"","help_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"city":{"element":"input_text","attributes":{"type":"text","name":"city","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"City","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"state":{"element":"input_text","attributes":{"type":"text","name":"state","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"State","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"zip":{"element":"input_text","attributes":{"type":"text","name":"zip","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Zip Code","admin_field_label":"","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"country":{"element":"select_country","attributes":{"name":"country","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Country","admin_field_label":"","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"country_list":{"active_list":"all","visible_list":[],"hidden_list":[]},"conditional_logics":[]},"options":{"BD":"Bangladesh","US":"US of America"},"editor_options":{"title":"Country List","element":"country-list","icon_class":"icon-text-width","template":"selectCountry"}}},"editor_options":{"title":"Address Fields","element":"address-fields","icon_class":"icon-credit-card","template":"addressFields"},"uniqElKey":"el_1559110782924"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_1","value":""},"settings":{"container_class":"","label":"How long have you lived in your given address? ","admin_field_label":"Lived in this address (years)","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"0-1 years":"0-1 years","1-2 years":"1-2 years","2-3 years":"2-3 years","3-4 years":"3-4 years","5+ years":"5+ years"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559110849005"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1559207478467"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Employment Information","description":"Put Your Employment Information bellow,\nPlease fill all the required.","align":"center","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1559110949366"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Present Employer ","label_placement":"","admin_field_label":"Present Employer ","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559111023883"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Occupation","label_placement":"","admin_field_label":"Occupation","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559111049075"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio_2","value":""},"settings":{"container_class":"","label":"Experience of work (years)","admin_field_label":"Experience of work (years)","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"0-1 years":"0-1 years","1-2 years":"1-2 years","2-3 years":"2-3 years","3-4 years":"3-4 years","5+ years":"5+ years"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559111110100"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_1","value":"","id":"","class":"","placeholder":"Ex 15000"},"settings":{"container_class":"","label":"Gross monthly income ","admin_field_label":"Gross monthly income ","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559111169812"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_2","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Monthly rent\/mortgage","admin_field_label":"Monthly rent\/mortgage","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559111225701"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field_3","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Down Payment Amount","admin_field_label":"Down Payment Amount","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":[]},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559111277768"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"Put your comments here (optional)","rows":4,"cols":2},"settings":{"container_class":"","label":"Comments","admin_field_label":"Comments","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559111302333"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"I have read and agree to the <a href=\"#\">Terms and Conditions<\/a> and <a href=\"#\">Privacy Policy<\/a>","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1559111347132"}],"submitButton":{"uniqElKey":"el_1559110346631","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Loan Application Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Loan Application Form submited","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'job_listing_form' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Job Listing Form',
                'is_pro'     => true,
                'brief'      => 'Get application and uploaded resume from online applicants.',
                'category'   => "HR",
                'tag'        => ["Job Listing", "HR", "office", "job"],
                'json'       => '[{"id":"17","title":"Job Listing Form","form":{"fields":[{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Personal informations","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1559205807740"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company Name","label_placement":"","admin_field_label":"Company Name","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118283900"},{"index":7,"element":"select","attributes":{"name":"dropdown","value":"","id":"","class":""},"settings":{"label":"Salutation","admin_field_label":"Salutation","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Mr":"Mr","Mrs":"Mrs","Miss":"Miss","Ms.":"Ms.","Dr.":"Dr.","Prof.":"Prof."},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559118312135"},{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Name","conditional_logics":[]},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"First Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559118403552"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Email address","label_placement":"","help_message":"","admin_field_label":"Email address","validation_rules":{"required":{"value":false,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559205920436"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition","value":false,"class":""},"settings":{"tnc_html":"Agree to show contact information in public posting (optional)","has_checkbox":true,"admin_field_label":"Terms and Conditions","container_class":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1559118426293"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1559189413198"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Information of your Position ","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1559118465186"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_1","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Company Name","label_placement":"","admin_field_label":"Company Name","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118495931"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_2","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Department \/ Division","label_placement":"","admin_field_label":"Department \/ Division","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118508878"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_3","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Position Title","label_placement":"","admin_field_label":"Position Title","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118527032"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_4","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Reference Number","label_placement":"","admin_field_label":"Reference Number","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118539776"},{"index":11,"element":"input_url","attributes":{"type":"url","name":"url","value":"","class":"","placeholder":"ex. http:\/\/www.example.com\/"},"settings":{"container_class":"","label":"Job Posting Url","admin_field_label":"Job Posting Url","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"url":{"value":true,"message":"This field must contain a valid url"}},"conditional_logics":[]},"editor_options":{"title":"Website URL","icon_class":"icon-link","template":"inputText"},"uniqElKey":"el_1559118552911"},{"index":2,"element":"input_text","attributes":{"type":"text","name":"input_text_5","value":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Salary Details","label_placement":"","admin_field_label":"Salary Details","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Simple Text","icon_class":"icon-text-width","template":"inputText"},"uniqElKey":"el_1559118570345"},{"index":5,"element":"terms_and_condition","attributes":{"type":"checkbox","name":"terms-n-condition_1","value":false,"class":""},"settings":{"tnc_html":"Salary Negotiable","has_checkbox":true,"admin_field_label":"Salary Negotiable","container_class":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"Terms & Conditions","icon_class":"icon-check-square-o","template":"termsCheckbox"},"uniqElKey":"el_1559118595891"},{"index":7,"element":"select","attributes":{"name":"dropdown_1","value":"","id":"","class":""},"settings":{"label":"Type of Employment","admin_field_label":"Type of Employment","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Full time":"Full time","Part time":"Part time"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559118624957"},{"index":7,"element":"select","attributes":{"name":"dropdown_2","value":"","id":"","class":""},"settings":{"label":"Type of Contract","admin_field_label":"","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"permanent":"permanent","Term\/Contract":"Term\/Contract","Locum":"Locum"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559118667887"},{"index":7,"element":"select","attributes":{"name":"dropdown_3","value":"","id":"","class":""},"settings":{"label":"Type Of the Position","admin_field_label":"Type Of the Position","help_message":"","container_class":"","label_placement":"","placeholder":"- Select -","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{"Academic":"Academic","Administrative":"Administrative","Obstetrics":"Obstetrics","Gynaecology":"Gynaecology","Obstetrics\/Gynaecology":"Obstetrics\/Gynaecology","Other":"Other"},"editor_options":{"title":"Dropdown","icon_class":"icon-caret-square-o-down","element":"select","template":"select"},"uniqElKey":"el_1559118729498"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Job Summary","admin_field_label":"Job Summary","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559118826214"},{"index":3,"element":"textarea","attributes":{"name":"description_1","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Roles and Responsibilities","admin_field_label":"Roles and Responsibilities","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559118841680"},{"index":3,"element":"textarea","attributes":{"name":"description_2","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Skills and Competencies","admin_field_label":"Skills and Competencies","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559118857624"},{"index":3,"element":"textarea","attributes":{"name":"description_3","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Education and Experience","admin_field_label":"Education and Experience","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559118873772"},{"index":3,"element":"textarea","attributes":{"name":"description_4","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"Other","admin_field_label":"Other","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559118895131"},{"index":14,"element":"input_file","attributes":{"type":"file","name":"file-upload","value":"","id":"","class":""},"settings":{"container_class":"","label":"Upload your Cv","admin_field_label":"CV","label_placement":"right","btn_text":"Choose File","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"},"max_file_size":{"value":5242880,"_valueFrom":"MB","message":"Maximum file size limit"},"max_file_count":{"value":"-1","message":"Max file count"},"allowed_file_types":{"value":["pdf"],"message":"allowed_file_types"}},"conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"editor_options":{"title":"File Upload","icon_class":"icon-upload","template":"inputFile"},"uniqElKey":"el_1559282340628"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Start Date of Employment","admin_field_label":"Start Date of Employment","label_placement":"","date_format":"M\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559118920295"},{"index":13,"element":"input_date","attributes":{"type":"text","name":"datetime_1","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Application Deadline","admin_field_label":"Application Deadline","label_placement":"","date_format":"M\/d\/Y","help_message":"","is_time_enabled":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Time & Date","icon_class":"icon-calendar-o","template":"inputText"},"uniqElKey":"el_1559118959353"},{"index":7,"element":"form_step","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""},"next_btn":{"type":"default","text":"Next","img_url":""}},"editor_options":{"title":"Form Step","icon_class":"icon-step-forward","template":"formStep"},"uniqElKey":"el_1559189453510"},{"index":1,"element":"section_break","attributes":{"id":"","class":""},"settings":{"label":"Payment Information","description":"","align":"left","conditional_logics":[]},"editor_options":{"title":"Section Break","icon_class":"icon-puzzle-piece","template":"sectionBreak"},"uniqElKey":"el_1559118987496"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Salary Amount","admin_field_label":"Salary Amount","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"options":{" $ 400.00 - 1 Month Posting Duration":" $ 400.00 - 1 Month Posting Duration","$ 600.00 - 2 Month Posting Duration":"$ 600.00 - 2 Month Posting Duration"," $ 900.00 - 3 Month Posting Duration":" $ 900.00 - 3 Month Posting Duration","other":"other"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559119006582"},{"index":6,"element":"input_number","attributes":{"type":"number","name":"numeric-field","value":"","id":"","class":"","placeholder":"Ex. 1000 "},"settings":{"container_class":"","label":"salary amount ($)","admin_field_label":"salary amount","label_placement":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"},"numeric":{"value":true,"message":"This field must contain numeric value"},"min":{"value":"","message":"Minimum value is "},"max":{"value":"","message":"Maximum value is "}},"conditional_logics":{"type":"any","status":true,"conditions":[{"field":"input_radio","value":"other","operator":"="}]}},"editor_options":{"title":"Numeric Field","icon_class":"icon-slack","template":"inputText"},"uniqElKey":"el_1559189169554"}],"submitButton":{"uniqElKey":"el_1559118268163","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit Form","img_url":""}},"editor_options":{"title":"Submit Button"}},"stepsWrapper":{"stepStart":{"element":"step_start","attributes":{"id":"","class":""},"settings":{"progress_indicator":"","step_titles":[]},"editor_options":{"title":"Start Paging"}},"stepEnd":{"element":"step_end","attributes":{"id":"","class":""},"settings":{"prev_btn":{"type":"default","text":"Previous","img_url":""}},"editor_options":{"title":"End Paging"}}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":"Job Listing Form Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Job Listing Form submission","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),

            'website_feedback' => array(
                'screenshot' => '',
                'createable' => true,
                'title'      => 'Website Feedback',
                'is_pro'     => true,
                'brief'      => 'To make effective for your site users, you may get the feedback and suggestions using this sample form.',
                'category'   => "IT",
                'tag'        => ["IT", "website", "tech", "feedback"],
                'json'       => '[{"id":"12","title":"Website Feedback","form":{"fields":[{"index":0,"element":"input_name","attributes":{"name":"names","data-type":"name-element"},"settings":{"container_class":"","admin_field_label":"Full Name","conditional_logics":{"type":"any","status":false,"conditions":[{"field":"","value":"","operator":""}]}},"fields":{"first_name":{"element":"input_text","attributes":{"type":"text","name":"first_name","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Enter Your Full Name","help_message":"","visible":true,"validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"middle_name":{"element":"input_text","attributes":{"type":"text","name":"middle_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Middle Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}},"last_name":{"element":"input_text","attributes":{"type":"text","name":"last_name","value":"","id":"","class":"","placeholder":"","required":false},"settings":{"container_class":"","label":"Last Name","help_message":"","error_message":"","visible":false,"validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"template":"inputText"}}},"editor_options":{"title":"Name Fields","element":"name-fields","icon_class":"icon-user","template":"nameFields"},"uniqElKey":"el_1559114141631"},{"index":1,"element":"input_email","attributes":{"type":"email","name":"email","value":"","id":"","class":"","placeholder":""},"settings":{"container_class":"","label":"Your Email address","label_placement":"","help_message":"","admin_field_label":"Email","validation_rules":{"required":{"value":true,"message":"This field is required"},"email":{"value":true,"message":"This field must contain a valid email"}},"conditional_logics":[]},"editor_options":{"title":"Email Address","icon_class":"icon-envelope-o","template":"inputText"},"uniqElKey":"el_1559114139212"},{"index":8,"element":"input_radio","attributes":{"type":"radio","name":"input_radio","value":""},"settings":{"container_class":"","label":"Is this the first time you have visited the website?","admin_field_label":"Is this the first time you have visited the website?","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"yes":"Yes","no":"No"},"editor_options":{"title":"Radio Button","icon_class":"icon-dot-circle-o","element":"input-radio","template":"inputRadio"},"uniqElKey":"el_1559114154264"},{"index":3,"element":"textarea","attributes":{"name":"description","value":"","id":"","class":"","placeholder":"","rows":4,"cols":2},"settings":{"container_class":"","label":"What is the PRIMARY reason you came to the site?","admin_field_label":"What is the PRIMARY reason you came to the site?","label_placement":"","help_message":"","validation_rules":{"required":{"value":false,"message":"This field is required"}},"conditional_logics":[]},"editor_options":{"title":"Text Area","icon_class":"icon-paragraph","template":"inputTextarea"},"uniqElKey":"el_1559114186791"},{"index":9,"element":"input_checkbox","attributes":{"type":"checkbox","name":"checkbox","value":[]},"settings":{"container_class":"","label":"Did you find what you needed?","admin_field_label":"Did you find what you needed?","label_placement":"","display_type":"","help_message":"","validation_rules":{"required":{"value":true,"message":"This field is required"}},"conditional_logics":[]},"options":{"Yes, all of it":"Yes, all of it","Yes, some of it":"Yes, some of it","No, none of it":"No, none of it"},"editor_options":{"title":"Check Box","icon_class":"icon-check-square-o","template":"inputCheckbox"},"uniqElKey":"el_1559114208705"},{"index":8,"element":"ratings","attributes":{"class":"","value":0,"name":"ratings"},"settings":{"label":"User Friendlyness","show_text":false,"help_message":"","label_placement":"","admin_field_label":"User Friendlyness","container_class":"","conditional_logics":[],"validation_rules":{"required":{"value":true,"message":"This field is required"}}},"options":{"1":"Nice","2":"Good","3":"Very Good","4":"Awesome","5":"Amazing"},"editor_options":{"title":"Ratings","icon_class":"icon-eye-slash","template":"ratings"},"uniqElKey":"el_1559114515484"}],"submitButton":{"uniqElKey":"el_1559114078404","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Send your feedback","img_url":""}},"editor_options":{"title":"Submit Button"}}},"formSettings":{"confirmation":{"redirectTo":"samePage","messageToShow":"Thank you for your message. We will get in touch with you shortly","customPage":null,"samePageFormBehavior":"hide_form","customUrl":null},"restrictions":{"limitNumberOfEntries":{"enabled":false,"numberOfEntries":null,"period":"total","limitReachedMsg":"Maximum number of entries exceeded."},"scheduleForm":{"enabled":false,"start":null,"end":null,"pendingMsg":"Form submission is not started yet.","expiredMsg":"Form submission is now closed."},"requireLogin":{"enabled":false,"requireLoginMsg":"You must be logged in to submit the form."},"denyEmptySubmission":{"enabled":false,"message":"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say."}},"layout":{"labelPlacement":"top","helpMessagePlacement":"with_label","errorMessagePlacement":"inline","cssClassName":""}},"notifications":{"name":" Website Feedback Notification","sendTo":{"type":"email","email":"{wp.admin_email}","field":null,"routing":[{"email":null,"field":null,"operator":"=","value":null}]},"fromName":"","fromEmail":"","replyTo":"","bcc":"","subject":"Website Feedback","message":"<p>{all_data}<\/p>","conditionals":{"status":false,"type":"all","conditions":[{"field":null,"operator":"=","value":null}]},"enabled":false,"email_template":""}}]'
            ),
        );

        return apply_filters('fluentform_predefined_forms', $forms);
    }

    private function getBlankConversationalForm()
    {
        return [
            'screenshot' => '',
            'createable' => true,
            'title'      => 'Conversational Form',
            'brief'      => 'Create Smart form UI',
            'category'   => 'Basic',
            'tags'       => ['contact', 'typeform', 'conversational', 'form'],
            'json'       => '[{"id":"12","title":"Conversational Form","status":"published","appearance_settings":null,"form_fields":{"fields":[],"submitButton":{"uniqElKey":"el_1524065200616","element":"button","attributes":{"type":"submit","class":""},"settings":{"align":"left","button_style":"default","container_class":"","help_message":"","background_color":"#409EFF","button_size":"md","color":"#ffffff","button_ui":{"type":"default","text":"Submit","img_url":""},"normal_styles":{"backgroundColor":"#409EFF","borderColor":"#409EFF","color":"#ffffff","borderRadius":"","minWidth":""},"hover_styles":{"backgroundColor":"#ffffff","borderColor":"#409EFF","color":"#409EFF","borderRadius":"","minWidth":""},"current_state":"normal_styles"},"editor_options":{"title":"Submit Button"}}},"has_payment":"0","type":"form","conditions":null,"created_by":"1","created_at":"2021-06-01 06:04:42","updated_at":"2021-06-01 06:05:49","metas":[{"meta_key":"formSettings","value":"{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"<h2>Thank you for your message. We will get in touch with you shortly</h2>\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\",\"selectedDays\":[\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\",\"Sunday\"]},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let us hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"},{"meta_key":"notifications","value":"{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}</p> <p>This form submitted at: {embed_post.permalink}</p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}"},{"meta_key":"is_conversion_form","value":"yes"}]}]'];
    }

    /**
     * Fetch simplified information for all predefined forms
     */
    public function all()
    {
        if (!App\Modules\Acl\Acl::hasAnyFormPermission()) {
            return [];
        }

        $data = array(
            'Basic' => []
        );

        foreach ($this->getPredefinedForms() as $key => $item) {
            if (!$item['category']) {
                $item['category'] = 'Other';
            }

            if (!isset($data[$item['category']])) {
                $data[$item['category']] = [];
            }

            $itemClass = 'item_' . str_replace([' ', '&', '/'], '_', strtolower($item['category']));

            if (empty($item['screenshot'])) {
                $itemClass .= ' item_no_image';
            } else {
                $itemClass .= ' item_has_image';
            }

            $data[$item['category']][$key] = array(
                'class'      => $itemClass,
                'tags'       => ArrayHelper::get($item, 'tag', ''),
                'title'      => $item['title'],
                'brief'      => $item['brief'],
                'category'   => $item['category'],
                'screenshot' => $item['screenshot'],
                'createable' => $item['createable'],
                'is_pro'     => ArrayHelper::get($item, 'is_pro'),
                'type'       => isset($item['type']) ? $item['type'] : 'form',
            );
        }

        wp_send_json([
            'forms'                     => $data,
            'categories'                => array_keys($data),
            'predefined_dropDown_forms' => apply_filters('fluentform-predefined-dropDown-forms', [
                'post' => [
                    'title' => 'Post Form',
                ]
            ])
        ], 200);
    }

    /**
     * Create a predefined form
     * @param $name
     */
    public function create()
    {
        $predefined = $this->request->get('predefined');

        if ($this->request->get('type') == 'blank_conversational') {
            $predefinedForm = $this->getBlankConversationalForm();
        } else {
            $predefinedForm = ArrayHelper::get($this->getPredefinedForms(), $predefined);
        }
        if ($predefinedForm) {
            $predefinedForm = json_decode($predefinedForm['json'], true)[0];
            $returnData = $this->createForm($predefinedForm, $predefined);
            wp_send_json_success($returnData, 200);
        }

        wp_send_json_error([
            'message' => __("The selected template couldn't be found.", 'fluentform')
        ], 422);
    }


    public function createForm($predefinedForm, $predefinedName = '')
    {
        $this->request->merge([
            'title' => $this->request->get('title', $predefinedForm['title'])
        ]);
    
        if (isset($predefinedForm['form_fields'])) {
            $this->formFields = json_encode($predefinedForm['form_fields']);
        } else {
            if (isset($predefinedForm['form'])) {
                $this->formFields = json_encode($predefinedForm['form']);
            }
        }
        //take global default setting when creating new form
        $defaultSettings = (new \FluentForm\App\Modules\Form\Form(wpFluentForm()))->getFormsDefaultSettings();
        $this->defaultSettings = apply_filters('fluentform_create_default_settings', $defaultSettings);
    
        $predefinedForm['metas'][] = [
            'meta_key' => 'formSettings',
            'value'    => json_encode($this->defaultSettings)
        ];

        if (isset($predefinedForm['notifications'])) {
            $this->defaultNotifications = $predefinedForm['notifications'];
            $predefinedForm['metas'][] = [
                'meta_key' => 'notifications',
                'value' => json_encode($this->defaultNotifications)
            ];
        }

        if($predefinedName) {
            if(empty($predefinedForm['metas'])) {
                $predefinedForm['metas'] = [];
            }
            $predefinedForm['metas'][] = [
                'meta_key' => 'template_name',
                'value' => $predefinedName
            ];
        }


        if (isset($predefinedForm['metas'])) {
            $this->metas = $predefinedForm['metas'];
        }

        if (!empty($predefinedForm['has_payment'])) {
            $this->hasPayment = 1;
        }

        if (!empty($predefinedForm['type'])) {
            $this->formType = $predefinedForm['type'];
        }

        return $this->store(false);
    }

    private function getRandomPhoto()
    {
        $photos = [
            'demo_1.jpg',
            'demo_2.jpg',
            'demo_3.jpg',
            'demo_4.jpg',
            'demo_5.jpg'
        ];

        $selected = array_rand($photos, 1);

        $photoName = $photos[$selected];

        return fluentformMix('img/conversational/' . $photoName);

    }

}

