<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber\AssignedAddOn\AssignedAddOnExtensionList;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 *
 * @property \Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber\AssignedAddOn\AssignedAddOnExtensionList extensions
 * @method \Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber\AssignedAddOn\AssignedAddOnExtensionContext extensions( string $sid )
 */
class AssignedAddOnContext extends InstanceContext {
	protected $_extensions = null;

	/**
	 * Initialize the AssignedAddOnContext
	 *
	 * @param \Twilio\Version $version Version that contains the resource
	 * @param string $accountSid The account_sid
	 * @param string $resourceSid The resource_sid
	 * @param string $sid The unique Installed Add-on Sid
	 *
	 * @return \Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber\AssignedAddOnContext
	 */
	public function __construct( Version $version, $accountSid, $resourceSid, $sid ) {
		parent::__construct( $version );

		// Path Solution
		$this->solution = array( 'accountSid' => $accountSid, 'resourceSid' => $resourceSid, 'sid' => $sid, );

		$this->uri = '/Accounts/' . rawurlencode( $accountSid ) . '/IncomingPhoneNumbers/' . rawurlencode( $resourceSid ) . '/AssignedAddOns/' . rawurlencode( $sid ) . '.json';
	}

	/**
	 * Fetch a AssignedAddOnInstance
	 *
	 * @return AssignedAddOnInstance Fetched AssignedAddOnInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function fetch() {
		$params = Values::of( array() );

		$payload = $this->version->fetch(
			'GET',
			$this->uri,
			$params
		);

		return new AssignedAddOnInstance(
			$this->version,
			$payload,
			$this->solution['accountSid'],
			$this->solution['resourceSid'],
			$this->solution['sid']
		);
	}

	/**
	 * Deletes the AssignedAddOnInstance
	 *
	 * @return boolean True if delete succeeds, false otherwise
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function delete() {
		return $this->version->delete( 'delete', $this->uri );
	}

	/**
	 * Magic getter to lazy load subresources
	 *
	 * @param string $name Subresource to return
	 *
	 * @return \Twilio\ListResource The requested subresource
	 * @throws \Twilio\Exceptions\TwilioException For unknown subresources
	 */
	public function __get( $name ) {
		if ( property_exists( $this, '_' . $name ) ) {
			$method = 'get' . ucfirst( $name );

			return $this->$method();
		}

		throw new TwilioException( 'Unknown subresource ' . $name );
	}

	/**
	 * Magic caller to get resource contexts
	 *
	 * @param string $name Resource to return
	 * @param array $arguments Context parameters
	 *
	 * @return \Twilio\InstanceContext The requested resource context
	 * @throws \Twilio\Exceptions\TwilioException For unknown resource
	 */
	public function __call( $name, $arguments ) {
		$property = $this->$name;
		if ( method_exists( $property, 'getContext' ) ) {
			return call_user_func_array( array( $property, 'getContext' ), $arguments );
		}

		throw new TwilioException( 'Resource does not have a context' );
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$context = array();
		foreach ( $this->solution as $key => $value ) {
			$context[] = "$key=$value";
		}

		return '[Twilio.Api.V2010.AssignedAddOnContext ' . implode( ' ', $context ) . ']';
	}

	/**
	 * Access the extensions
	 *
	 * @return \Twilio\Rest\Api\V2010\Account\IncomingPhoneNumber\AssignedAddOn\AssignedAddOnExtensionList
	 */
	protected function getExtensions() {
		if ( ! $this->_extensions ) {
			$this->_extensions = new AssignedAddOnExtensionList(
				$this->version,
				$this->solution['accountSid'],
				$this->solution['resourceSid'],
				$this->solution['sid']
			);
		}

		return $this->_extensions;
	}
}