<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Api\V2010\Account\Message;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class MediaTest extends HolodeckTestCase {
	public function testDeleteRequest() {
		$this->holodeck->mock( new Response( 500, '' ) );

		try {
			$this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			                         ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			                         ->media( "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )->delete();
		} catch ( DeserializeException $e ) {
		} catch ( TwilioException $e ) {
		}

		$this->assertRequest( new Request(
			'delete',
			'https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media/MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.json'
		) );
	}

	public function testDeleteResponse() {
		$this->holodeck->mock( new Response(
			204,
			null
		) );

		$actual = $this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->media( "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )->delete();

		$this->assertTrue( $actual );
	}

	public function testFetchRequest() {
		$this->holodeck->mock( new Response( 500, '' ) );

		try {
			$this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			                         ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			                         ->media( "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )->fetch();
		} catch ( DeserializeException $e ) {
		} catch ( TwilioException $e ) {
		}

		$this->assertRequest( new Request(
			'get',
			'https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media/MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.json'
		) );
	}

	public function testFetchResponse() {
		$this->holodeck->mock( new Response(
			200,
			'
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "content_type": "image/jpeg",
                "date_created": "Sun, 16 Aug 2015 15:53:54 +0000",
                "date_updated": "Sun, 16 Aug 2015 15:53:55 +0000",
                "parent_sid": "SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media/MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.json"
            }
            '
		) );

		$actual = $this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->media( "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )->fetch();

		$this->assertNotNull( $actual );
	}

	public function testReadRequest() {
		$this->holodeck->mock( new Response( 500, '' ) );

		try {
			$this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			                         ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
				->media->read();
		} catch ( DeserializeException $e ) {
		} catch ( TwilioException $e ) {
		}

		$this->assertRequest( new Request(
			'get',
			'https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json'
		) );
	}

	public function testReadFullResponse() {
		$this->holodeck->mock( new Response(
			200,
			'
            {
                "end": 0,
                "first_page_uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0",
                "last_page_uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0",
                "media_list": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "content_type": "image/jpeg",
                        "date_created": "Sun, 16 Aug 2015 15:53:54 +0000",
                        "date_updated": "Sun, 16 Aug 2015 15:53:55 +0000",
                        "parent_sid": "SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media/MEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.json"
                    }
                ],
                "next_page_uri": null,
                "num_pages": 1,
                "page": 0,
                "page_size": 50,
                "previous_page_uri": null,
                "start": 0,
                "total": 1,
                "uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0"
            }
            '
		) );

		$actual = $this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			->media->read();

		$this->assertGreaterThan( 0, count( $actual ) );
	}

	public function testReadEmptyResponse() {
		$this->holodeck->mock( new Response(
			200,
			'
            {
                "end": 0,
                "first_page_uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0",
                "last_page_uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0",
                "media_list": [],
                "next_page_uri": null,
                "num_pages": 1,
                "page": 0,
                "page_size": 50,
                "previous_page_uri": null,
                "start": 0,
                "total": 1,
                "uri": "/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Messages/SMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media.json?PageSize=50&Page=0"
            }
            '
		) );

		$actual = $this->twilio->api->v2010->accounts( "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
		                                   ->messages( "MMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" )
			->media->read();

		$this->assertNotNull( $actual );
	}
}